/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.springframework.social.ResourceNotFoundException;
import org.springframework.social.twitter.api.CursoredList;
import org.springframework.social.twitter.api.ListOperations;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.TwitterProfile;
import org.springframework.social.twitter.api.UserList;
import org.springframework.social.twitter.api.impl.AbstractTwitterOperations;
import org.springframework.social.twitter.api.impl.ArrayUtils;
import org.springframework.social.twitter.api.impl.PagingUtils;
import org.springframework.social.twitter.api.impl.TwitterProfileUsersList;
import org.springframework.social.twitter.api.impl.UserListList;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListTemplate
extends AbstractTwitterOperations
implements ListOperations {
    private final RestTemplate restTemplate;

    public ListTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public CursoredList<UserList> getLists() {
        return this.getListsInCursor(-1L);
    }

    @Override
    public CursoredList<UserList> getListsInCursor(long cursor) {
        this.requireAuthorization();
        return ((UserListList)this.restTemplate.getForObject(this.buildUri("lists.json", "cursor", String.valueOf(cursor)), UserListList.class)).getList();
    }

    @Override
    public CursoredList<UserList> getLists(long userId) {
        return this.getListsInCursor(userId, -1L);
    }

    @Override
    public CursoredList<UserList> getListsInCursor(long userId, long cursor) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"user_id", (Object)String.valueOf(userId));
        parameters.set((Object)"cursor", (Object)String.valueOf(cursor));
        return ((UserListList)this.restTemplate.getForObject(this.buildUri("lists.json", (MultiValueMap<String, String>)parameters), UserListList.class)).getList();
    }

    @Override
    public CursoredList<UserList> getLists(String screenName) {
        return this.getListsInCursor(screenName, -1L);
    }

    @Override
    public CursoredList<UserList> getListsInCursor(String screenName, long cursor) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"screen_name", (Object)screenName);
        parameters.set((Object)"cursor", (Object)String.valueOf(cursor));
        return ((UserListList)this.restTemplate.getForObject(this.buildUri("lists.json", (MultiValueMap<String, String>)parameters), UserListList.class)).getList();
    }

    @Override
    public UserList getList(long listId) {
        return (UserList)this.restTemplate.getForObject(this.buildUri("lists/show.json", "list_id", String.valueOf(listId)), UserList.class);
    }

    @Override
    public UserList getList(String screenName, String listSlug) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"owner_screen_name", (Object)screenName);
        parameters.set((Object)"slug", (Object)listSlug);
        return (UserList)this.restTemplate.getForObject(this.buildUri("lists/show.json", (MultiValueMap<String, String>)parameters), UserList.class);
    }

    @Override
    public List<Tweet> getListStatuses(long listId) {
        return this.getListStatuses(listId, 1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getListStatuses(long listId, int page, int pageSize) {
        return this.getListStatuses(listId, page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getListStatuses(long listId, int page, int pageSize, long sinceId, long maxId) {
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithPerPage(page, pageSize, sinceId, maxId);
        parameters.set((Object)"list_id", (Object)String.valueOf(listId));
        return (List)this.restTemplate.getForObject(this.buildUri("lists/statuses.json", parameters), TweetList.class);
    }

    @Override
    public List<Tweet> getListStatuses(String screenName, String listSlug) {
        return this.getListStatuses(screenName, listSlug, 1, 20, 0L, 0L);
    }

    @Override
    public List<Tweet> getListStatuses(String screenName, String listSlug, int page, int pageSize) {
        return this.getListStatuses(screenName, listSlug, page, pageSize, 0L, 0L);
    }

    @Override
    public List<Tweet> getListStatuses(String screenName, String listSlug, int page, int pageSize, long sinceId, long maxId) {
        MultiValueMap<String, String> parameters = PagingUtils.buildPagingParametersWithPerPage(page, pageSize, sinceId, maxId);
        parameters.set((Object)"owner_screen_name", (Object)screenName);
        parameters.set((Object)"slug", (Object)listSlug);
        return (List)this.restTemplate.getForObject(this.buildUri("lists/statuses.json", parameters), TweetList.class);
    }

    @Override
    public UserList createList(String name, String description, boolean isPublic) {
        this.requireAuthorization();
        MultiValueMap<String, Object> request = this.buildListDataMap(name, description, isPublic);
        return (UserList)this.restTemplate.postForObject(this.buildUri("lists/create.json"), request, UserList.class);
    }

    @Override
    public UserList updateList(long listId, String name, String description, boolean isPublic) {
        this.requireAuthorization();
        MultiValueMap<String, Object> request = this.buildListDataMap(name, description, isPublic);
        request.set((Object)"list_id", (Object)String.valueOf(listId));
        return (UserList)this.restTemplate.postForObject(this.buildUri("lists/update.json"), request, UserList.class);
    }

    @Override
    public void deleteList(long listId) {
        this.requireAuthorization();
        this.restTemplate.delete(this.buildUri("lists/destroy.json", "list_id", String.valueOf(listId)));
    }

    @Override
    public List<TwitterProfile> getListMembers(long listId) {
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("lists/members.json", "list_id", String.valueOf(listId)), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public List<TwitterProfile> getListMembers(String screenName, String listSlug) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"owner_screen_name", (Object)screenName);
        parameters.set((Object)"slug", (Object)listSlug);
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("lists/members.json", (MultiValueMap<String, String>)parameters), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public UserList addToList(long listId, long ... newMemberIds) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"user_id", (Object)ArrayUtils.join(newMemberIds));
        request.set((Object)"list_id", (Object)String.valueOf(listId));
        return (UserList)this.restTemplate.postForObject(this.buildUri("lists/members/create_all.json"), (Object)request, UserList.class);
    }

    @Override
    public UserList addToList(long listId, String ... newMemberScreenNames) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"screen_name", (Object)ArrayUtils.join(newMemberScreenNames));
        request.set((Object)"list_id", (Object)String.valueOf(listId));
        return (UserList)this.restTemplate.postForObject(this.buildUri("lists/members/create_all.json"), (Object)request, UserList.class);
    }

    @Override
    public void removeFromList(long listId, long memberId) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"user_id", (Object)String.valueOf(memberId));
        request.set((Object)"list_id", (Object)String.valueOf(listId));
        this.restTemplate.postForObject(this.buildUri("lists/members/destroy.json"), (Object)request, String.class);
    }

    @Override
    public void removeFromList(long listId, String memberScreenName) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"screen_name", (Object)String.valueOf(memberScreenName));
        request.set((Object)"list_id", (Object)String.valueOf(listId));
        this.restTemplate.postForObject(this.buildUri("lists/members/destroy.json"), (Object)request, String.class);
    }

    @Override
    public List<TwitterProfile> getListSubscribers(long listId) {
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("lists/subscribers.json", "list_id", String.valueOf(listId)), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public List<TwitterProfile> getListSubscribers(String screenName, String listSlug) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"owner_screen_name", (Object)screenName);
        parameters.set((Object)"slug", (Object)listSlug);
        return ((TwitterProfileUsersList)this.restTemplate.getForObject(this.buildUri("lists/subscribers.json", (MultiValueMap<String, String>)parameters), TwitterProfileUsersList.class)).getList();
    }

    @Override
    public UserList subscribe(long listId) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"list_id", (Object)String.valueOf(listId));
        return (UserList)this.restTemplate.postForObject(this.buildUri("lists/subscribers/create.json"), (Object)request, UserList.class);
    }

    @Override
    public UserList subscribe(String ownerScreenName, String listSlug) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"owner_screen_name", (Object)ownerScreenName);
        request.set((Object)"slug", (Object)listSlug);
        return (UserList)this.restTemplate.postForObject(this.buildUri("lists/subscribers/create.json"), (Object)request, UserList.class);
    }

    @Override
    public UserList unsubscribe(long listId) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"list_id", (Object)String.valueOf(listId));
        return (UserList)this.restTemplate.postForObject(this.buildUri("lists/subscribers/destroy.json"), (Object)request, UserList.class);
    }

    @Override
    public UserList unsubscribe(String ownerScreenName, String listSlug) {
        this.requireAuthorization();
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"owner_screen_name", (Object)ownerScreenName);
        request.set((Object)"slug", (Object)listSlug);
        return (UserList)this.restTemplate.postForObject(this.buildUri("lists/subscribers/destroy.json"), (Object)request, UserList.class);
    }

    @Override
    public CursoredList<UserList> getMemberships(long userId) {
        return ((UserListList)this.restTemplate.getForObject(this.buildUri("lists/memberships.json", "user_id", String.valueOf(userId)), UserListList.class)).getList();
    }

    @Override
    public CursoredList<UserList> getMemberships(String screenName) {
        return ((UserListList)this.restTemplate.getForObject(this.buildUri("lists/memberships.json", "screen_name", screenName), UserListList.class)).getList();
    }

    @Override
    public CursoredList<UserList> getSubscriptions(long userId) {
        return ((UserListList)this.restTemplate.getForObject(this.buildUri("lists/subscriptions.json", "user_id", String.valueOf(userId)), UserListList.class)).getList();
    }

    @Override
    public CursoredList<UserList> getSubscriptions(String screenName) {
        return ((UserListList)this.restTemplate.getForObject(this.buildUri("lists/subscriptions.json", "screen_name", screenName), UserListList.class)).getList();
    }

    @Override
    public boolean isMember(long listId, long memberId) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"list_id", (Object)String.valueOf(listId));
        parameters.set((Object)"user_id", (Object)String.valueOf(memberId));
        return this.checkListConnection(this.buildUri("lists/members/show.json", (MultiValueMap<String, String>)parameters));
    }

    @Override
    public boolean isMember(String screenName, String listSlug, String memberScreenName) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"owner_screen_name", (Object)screenName);
        parameters.set((Object)"slug", (Object)listSlug);
        parameters.set((Object)"screen_name", (Object)memberScreenName);
        return this.checkListConnection(this.buildUri("lists/members/show.json", (MultiValueMap<String, String>)parameters));
    }

    @Override
    public boolean isSubscriber(long listId, long subscriberId) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"list_id", (Object)String.valueOf(listId));
        parameters.set((Object)"user_id", (Object)String.valueOf(subscriberId));
        return this.checkListConnection(this.buildUri("lists/subscribers/show.json", (MultiValueMap<String, String>)parameters));
    }

    @Override
    public boolean isSubscriber(String screenName, String listSlug, String subscriberScreenName) {
        this.requireAuthorization();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)"owner_screen_name", (Object)screenName);
        parameters.set((Object)"slug", (Object)listSlug);
        parameters.set((Object)"screen_name", (Object)subscriberScreenName);
        return this.checkListConnection(this.buildUri("lists/subscribers/show.json", (MultiValueMap<String, String>)parameters));
    }

    private boolean checkListConnection(URI uri) {
        try {
            this.restTemplate.getForObject(uri, String.class);
            return true;
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
    }

    private MultiValueMap<String, Object> buildListDataMap(String name, String description, boolean isPublic) {
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"name", (Object)name);
        request.set((Object)"description", (Object)description);
        request.set((Object)"mode", (Object)(isPublic ? "public" : "private"));
        return request;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TweetList
    extends ArrayList<Tweet> {
        private TweetList() {
        }
    }
}

