/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.util.Map;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoderProviderConfigurationUtils;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoderProviderConfigurationUtils;
import org.springframework.util.Assert;

public final class ReactiveJwtDecoders {
    private ReactiveJwtDecoders() {
    }

    public static <T extends ReactiveJwtDecoder> T fromOidcIssuerLocation(String oidcIssuerLocation) {
        Assert.hasText((String)oidcIssuerLocation, (String)"oidcIssuerLocation cannot be empty");
        Map<String, Object> configuration = JwtDecoderProviderConfigurationUtils.getConfigurationForOidcIssuerLocation(oidcIssuerLocation);
        return (T)ReactiveJwtDecoders.withProviderConfiguration(configuration, oidcIssuerLocation);
    }

    public static <T extends ReactiveJwtDecoder> T fromIssuerLocation(String issuer) {
        Assert.hasText((String)issuer, (String)"issuer cannot be empty");
        Map<String, Object> configuration = JwtDecoderProviderConfigurationUtils.getConfigurationForIssuerLocation(issuer);
        return (T)ReactiveJwtDecoders.withProviderConfiguration(configuration, issuer);
    }

    private static ReactiveJwtDecoder withProviderConfiguration(Map<String, Object> configuration, String issuer) {
        JwtDecoderProviderConfigurationUtils.validateIssuer(configuration, issuer);
        OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefaultWithIssuer(issuer);
        String jwkSetUri = configuration.get("jwks_uri").toString();
        NimbusReactiveJwtDecoder jwtDecoder = NimbusReactiveJwtDecoder.withJwkSetUri(jwkSetUri).jwtProcessorCustomizer(ReactiveJwtDecoderProviderConfigurationUtils::addJWSAlgorithms).build();
        jwtDecoder.setJwtValidator(jwtValidator);
        return jwtDecoder;
    }
}

