/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.alps;

import java.util.List;
import org.springframework.hateoas.alps.Descriptor;
import org.springframework.hateoas.alps.Doc;
import org.springframework.hateoas.alps.Ext;

public final class Alps {
    private final String version = "1.0";
    private final Doc doc;
    private final List<Descriptor> descriptors;

    public static Descriptor.DescriptorBuilder descriptor() {
        return Descriptor.builder();
    }

    public static Doc.DocBuilder doc() {
        return Doc.builder();
    }

    public static Ext.ExtBuilder ext() {
        return Ext.builder();
    }

    Alps(Doc doc, List<Descriptor> descriptors) {
        this.doc = doc;
        this.descriptors = descriptors;
    }

    public static AlpsBuilder alps() {
        return new AlpsBuilder();
    }

    public String getVersion() {
        return this.version;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public List<Descriptor> getDescriptors() {
        return this.descriptors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alps)) {
            return false;
        }
        Alps other = (Alps)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Doc this$doc = this.getDoc();
        Doc other$doc = other.getDoc();
        if (this$doc == null ? other$doc != null : !((Object)this$doc).equals(other$doc)) {
            return false;
        }
        List<Descriptor> this$descriptors = this.getDescriptors();
        List<Descriptor> other$descriptors = other.getDescriptors();
        return !(this$descriptors == null ? other$descriptors != null : !((Object)this$descriptors).equals(other$descriptors));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Doc $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : ((Object)$doc).hashCode());
        List<Descriptor> $descriptors = this.getDescriptors();
        result = result * 59 + ($descriptors == null ? 43 : ((Object)$descriptors).hashCode());
        return result;
    }

    public String toString() {
        return "Alps(version=" + this.getVersion() + ", doc=" + this.getDoc() + ", descriptors=" + this.getDescriptors() + ")";
    }

    public static class AlpsBuilder {
        private Doc doc;
        private List<Descriptor> descriptors;

        AlpsBuilder() {
        }

        public AlpsBuilder doc(Doc doc) {
            this.doc = doc;
            return this;
        }

        public AlpsBuilder descriptors(List<Descriptor> descriptors) {
            this.descriptors = descriptors;
            return this;
        }

        public Alps build() {
            return new Alps(this.doc, this.descriptors);
        }

        public String toString() {
            return "Alps.AlpsBuilder(doc=" + this.doc + ", descriptors=" + this.descriptors + ")";
        }
    }
}

