/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.data.json.converter.support;

import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.JSONFormatterException;
import org.apache.geode.pdx.PdxInstance;
import org.springframework.geode.data.json.converter.JsonToObjectConverter;
import org.springframework.geode.data.json.converter.JsonToPdxConverter;
import org.springframework.geode.data.json.converter.support.JacksonJsonToObjectConverter;
import org.springframework.geode.pdx.ObjectPdxInstanceAdapter;
import org.springframework.geode.pdx.PdxInstanceWrapper;
import org.springframework.lang.NonNull;

public class JSONFormatterJsonToPdxConverter
implements JsonToPdxConverter {
    private JsonToObjectConverter converter = this.newJsonToObjectConverter();

    private JsonToObjectConverter newJsonToObjectConverter() {
        return new JacksonJsonToObjectConverter();
    }

    @NonNull
    protected JsonToObjectConverter getJsonToObjectConverter() {
        return this.converter;
    }

    @NonNull
    public final PdxInstance convert(@NonNull String json) {
        try {
            return this.convertJsonToPdx(json);
        }
        catch (JSONFormatterException cause) {
            return this.convertJsonToObjectToPdx(json);
        }
    }

    @NonNull
    protected PdxInstance adapt(@NonNull Object target) {
        return ObjectPdxInstanceAdapter.from(target);
    }

    @NonNull
    protected PdxInstance convertJsonToObjectToPdx(@NonNull String json) {
        return this.adapt(this.getJsonToObjectConverter().convert(json));
    }

    @NonNull
    protected PdxInstance convertJsonToPdx(@NonNull String json) {
        return this.wrap(this.jsonFormatterFromJson(json));
    }

    @NonNull
    protected PdxInstance jsonFormatterFromJson(@NonNull String json) {
        return JSONFormatter.fromJSON((String)json);
    }

    @NonNull
    protected PdxInstanceWrapper wrap(@NonNull PdxInstance pdxInstance) {
        return PdxInstanceWrapper.from((PdxInstance)pdxInstance);
    }
}

