/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.io.support;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public enum ResourcePrefix {
    CLASSPATH_URL_PREFIX("classpath:"),
    FILESYSTEM_URL_PREFIX("file:"),
    HTTP_URL_PREFIX("http:");

    public static final String RESOURCE_PATH_SEPARATOR = "/";
    private final String prefix;

    @Nullable
    public static ResourcePrefix from(@Nullable String prefix) {
        if (StringUtils.hasText((String)prefix)) {
            prefix = prefix.trim().toLowerCase();
            for (ResourcePrefix resourcePrefix : ResourcePrefix.values()) {
                if (!resourcePrefix.toString().equals(prefix)) continue;
                return resourcePrefix;
            }
        }
        return null;
    }

    private ResourcePrefix(String prefix) {
        Assert.hasText((String)prefix, (String)"Resource prefix must be specified");
        this.prefix = prefix;
    }

    public String getProtocol() {
        StringBuilder buffer = new StringBuilder();
        for (char character : this.prefix.toCharArray()) {
            if (!Character.isAlphabetic(character)) continue;
            buffer.append(character);
        }
        return buffer.toString();
    }

    protected String getUrlPrefixPattern() {
        return this.equals((Object)CLASSPATH_URL_PREFIX) ? "%s" : "%1$s%2$s%2$s";
    }

    public String toString() {
        return this.prefix;
    }

    public String toUrlPrefix() {
        return String.format(this.getUrlPrefixPattern(), this.toString(), RESOURCE_PATH_SEPARATOR);
    }
}

