/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.io.support;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.geode.core.io.AbstractResourceWriter;
import org.springframework.geode.core.io.ResourceDataAccessException;
import org.springframework.geode.core.io.ResourceWriteException;
import org.springframework.geode.core.io.support.ResourceUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class FileResourceWriter
extends AbstractResourceWriter {
    protected static final boolean DEFAULT_APPEND_TO_FILE = false;
    protected static final int DEFAULT_BUFFER_SIZE = 16384;
    private final ThreadLocal<Resource> resource = new ThreadLocal();

    @Override
    protected void doWrite(OutputStream resourceOutputStream, byte[] data) {
        if (ResourceUtils.isNotEmpty(data)) {
            int bufferSize = this.getBufferSize();
            int length = Math.min(bufferSize, data.length);
            int offset = 0;
            try (OutputStream out = this.decorate(resourceOutputStream);){
                while (offset < data.length) {
                    out.write(data, offset, length);
                    length = Math.min(bufferSize, data.length - (offset += bufferSize));
                }
                out.flush();
            }
            catch (IOException cause) {
                String message = String.format("Failed to write data (%1$d byte(s)) to Resource using [%2$s]", data.length, this.getClass().getName());
                throw new ResourceWriteException(message, cause);
            }
        }
    }

    @Override
    protected boolean isAbleToHandle(@Nullable Resource resource) {
        if (super.isAbleToHandle(resource) && resource.isFile()) {
            this.resource.set(resource);
            return true;
        }
        return false;
    }

    protected int getBufferSize() {
        return 16384;
    }

    protected OpenOption[] getOpenOptions() {
        return (OpenOption[])ArrayUtils.asArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE});
    }

    protected Optional<Resource> getResource() {
        return Optional.ofNullable(this.resource.get());
    }

    @NonNull
    protected OutputStream decorate(@Nullable OutputStream outputStream) {
        return outputStream instanceof BufferedOutputStream ? outputStream : (outputStream != null ? new BufferedOutputStream(outputStream, this.getBufferSize()) : this.newFileOutputStream());
    }

    protected OutputStream newFileOutputStream() {
        return this.getResource().filter(this::isAbleToHandle).map(resource -> {
            try {
                OutputStream fileOutputStream = Files.newOutputStream(resource.getFile().toPath(), this.getOpenOptions());
                return new BufferedOutputStream(fileOutputStream, this.getBufferSize());
            }
            catch (IOException cause) {
                String message = String.format("Failed to access the Resource [%s] as a file", resource.getDescription());
                throw new ResourceDataAccessException(message, cause);
            }
        }).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"Resource [%s] is not a file based resource", (Object[])new Object[]{this.getResource().map(Resource::getDescription).orElse(null)}));
    }
}

