/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.io;

import java.io.IOException;
import java.io.OutputStream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.geode.core.io.ResourceWriteException;
import org.springframework.geode.core.io.ResourceWriter;
import org.springframework.geode.core.io.UnhandledResourceException;
import org.springframework.geode.core.io.support.ResourceUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class AbstractResourceWriter
implements ResourceWriter {
    @Override
    public void write(@NonNull Resource resource, byte[] data) {
        ResourceUtils.asWritableResource(resource).filter(this::isAbleToHandle).map(this::preProcess).map(it -> {
            try (OutputStream out = it.getOutputStream();){
                this.doWrite(out, data);
                Boolean bl = true;
                return bl;
            }
            catch (IOException cause) {
                throw new ResourceWriteException(String.format("Failed to write to Resource [%s]", it.getDescription()), cause);
            }
        }).orElseThrow(() -> new UnhandledResourceException(String.format("Unable to handle Resource [%s]", ResourceUtils.nullSafeGetDescription(resource))));
    }

    protected boolean isAbleToHandle(@Nullable Resource resource) {
        return resource != null;
    }

    protected abstract void doWrite(OutputStream var1, byte[] var2) throws IOException;

    @NonNull
    protected WritableResource preProcess(@NonNull WritableResource resource) {
        return resource;
    }
}

