/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.context.logging;

import java.util.Arrays;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GeodeLoggingApplicationListener
implements GenericApplicationListener {
    private static final Class<?>[] EVENT_TYPES = new Class[]{ApplicationEnvironmentPreparedEvent.class};
    private static final Class<?>[] SOURCE_TYPES = new Class[]{ApplicationContext.class, SpringApplication.class};
    public static final String SPRING_BOOT_DATA_GEMFIRE_LOG_LEVEL_PROPERTY = "spring.boot.data.gemfire.log.level";
    public static final String SPRING_DATA_GEMFIRE_CACHE_LOG_LEVEL = "spring.data.gemfire.cache.log-level";
    public static final String SPRING_DATA_GEMFIRE_LOGGING_LOG_LEVEL = "spring.data.gemfire.logging.level";

    public int getOrder() {
        return -2147483629;
    }

    public void onApplicationEvent(@Nullable ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            ApplicationEnvironmentPreparedEvent environmentPreparedEvent = (ApplicationEnvironmentPreparedEvent)event;
            this.onApplicationEnvironmentPreparedEvent(environmentPreparedEvent);
        }
    }

    protected void onApplicationEnvironmentPreparedEvent(@NonNull ApplicationEnvironmentPreparedEvent environmentPreparedEvent) {
        Assert.notNull((Object)environmentPreparedEvent, (String)"ApplicationEnvironmentPreparedEvent must not be null");
        ConfigurableEnvironment environment = environmentPreparedEvent.getEnvironment();
        if (this.isSystemPropertyNotSet(SPRING_BOOT_DATA_GEMFIRE_LOG_LEVEL_PROPERTY)) {
            String logLevel = environment.getProperty(SPRING_BOOT_DATA_GEMFIRE_LOG_LEVEL_PROPERTY, environment.getProperty(SPRING_DATA_GEMFIRE_LOGGING_LOG_LEVEL, environment.getProperty(SPRING_DATA_GEMFIRE_CACHE_LOG_LEVEL)));
            this.setSystemProperty(SPRING_BOOT_DATA_GEMFIRE_LOG_LEVEL_PROPERTY, logLevel);
        }
    }

    protected boolean isSystemPropertySet(@Nullable String propertyName) {
        return StringUtils.hasText((String)propertyName) && StringUtils.hasText((String)System.getProperty(propertyName));
    }

    protected boolean isSystemPropertyNotSet(@Nullable String propertyName) {
        return !this.isSystemPropertySet(propertyName);
    }

    protected void setSystemProperty(@NonNull String propertyName, @Nullable String propertyValue) {
        Assert.hasText((String)propertyName, () -> String.format("PropertyName [%s] is required", propertyName));
        if (StringUtils.hasText((String)propertyValue)) {
            System.setProperty(propertyName, propertyValue);
        }
    }

    public boolean supportsEventType(@NonNull ResolvableType eventType) {
        Class rawType = eventType.getRawClass();
        return rawType != null && Arrays.stream(EVENT_TYPES).anyMatch(it -> it.isAssignableFrom(rawType));
    }

    public boolean supportsSourceType(@Nullable Class<?> sourceType) {
        return sourceType != null && Arrays.stream(SOURCE_TYPES).anyMatch(it -> it.isAssignableFrom(sourceType));
    }
}

