/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.LocatorConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.geode.config.annotation.UseLocators;
import org.springframework.util.StringUtils;

@Configuration
public class LocatorsConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    protected static final String DEFAULT_LOCATORS = "localhost[10334]";
    protected static final String DEFAULT_REMOTE_LOCATORS = "";
    protected static final String LOCATORS_PROPERTY = "locators";
    protected static final String REMOTE_LOCATORS_PROPERTY = "remote-locators";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String locators;
    private String remoteLocators;

    protected Class<? extends Annotation> getAnnotationType() {
        return UseLocators.class;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes useLocatorsAttributes = this.getAnnotationAttributes(importMetadata);
            this.setLocators(useLocatorsAttributes.containsKey((Object)LOCATORS_PROPERTY) ? useLocatorsAttributes.getString(LOCATORS_PROPERTY) : null);
            this.setRemoteLocators(useLocatorsAttributes.containsKey((Object)"remoteLocators") ? useLocatorsAttributes.getString("remoteLocators") : null);
        }
    }

    protected void setLocators(String locators) {
        this.locators = StringUtils.hasText((String)locators) ? locators : null;
    }

    protected Optional<String> getLocators() {
        return Optional.ofNullable(this.locators).filter(StringUtils::hasText);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected void setRemoteLocators(String remoteLocators) {
        this.remoteLocators = StringUtils.hasText((String)remoteLocators) ? remoteLocators : null;
    }

    protected Optional<String> getRemoteLocators() {
        return Optional.ofNullable(this.remoteLocators).filter(StringUtils::hasText);
    }

    @Bean
    ClientCacheConfigurer clientCacheLocatorsConfigurer() {
        return (beanName, clientCacheFactoryBean) -> {
            Logger logger = this.getLogger();
            this.getLocators().ifPresent(locators -> {
                if (logger.isWarnEnabled()) {
                    logger.warn("The '{}' property was configured [{}]; however, this value does not have any effect for ClientCache instances", (Object)LOCATORS_PROPERTY, locators);
                }
            });
            this.getRemoteLocators().ifPresent(remoteLocators -> {
                if (logger.isWarnEnabled()) {
                    logger.warn("The '{}' property was configured [{}]; however, this value does not have any effect for ClientCache instances", (Object)REMOTE_LOCATORS_PROPERTY, remoteLocators);
                }
            });
        };
    }

    @Bean
    LocatorConfigurer locatorLocatorsConfigurer() {
        return (beanName, locatorFactoryBean) -> {
            Properties gemfireProperties = locatorFactoryBean.getGemFireProperties();
            this.getLocators().ifPresent(locators -> gemfireProperties.setProperty(LOCATORS_PROPERTY, (String)locators));
            this.getRemoteLocators().ifPresent(remoteLocators -> gemfireProperties.setProperty(REMOTE_LOCATORS_PROPERTY, (String)remoteLocators));
        };
    }

    @Bean
    PeerCacheConfigurer peerCacheLocatorsConfigurer() {
        return (beanName, cacheFactoryBean) -> {
            Properties gemfireProperties = cacheFactoryBean.getProperties();
            this.getLocators().ifPresent(locators -> gemfireProperties.setProperty(LOCATORS_PROPERTY, (String)locators));
            this.getRemoteLocators().ifPresent(remoteLocators -> gemfireProperties.setProperty(REMOTE_LOCATORS_PROPERTY, (String)remoteLocators));
        };
    }
}

