/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.config.annotation;

import org.apache.geode.cache.client.ClientRegionShortcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.gemfire.config.annotation.support.CacheTypeAwareRegionFactoryBean;
import org.springframework.geode.config.annotation.ClusterAwareConfiguration;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@Configuration
@Conditional(value={AllClusterNotAvailableConditions.class})
public class ClusterNotAvailableConfiguration {
    @Bean
    BeanPostProcessor localClientRegionBeanPostProcessor(final @NonNull Environment environment) {
        return new BeanPostProcessor(){

            @Nullable
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (ClusterNotAvailableConfiguration.this.isClientRegion(bean)) {
                    ClusterNotAvailableConfiguration.this.configureAsLocalClientRegion(environment, bean);
                }
                return bean;
            }
        };
    }

    @Bean
    RegionConfigurer localClientRegionConfigurer(final @NonNull Environment environment) {
        return new RegionConfigurer(){

            public void configure(String beanName, ClientRegionFactoryBean<?, ?> bean) {
                ClusterNotAvailableConfiguration.this.configureAsLocalClientRegion(environment, bean);
            }
        };
    }

    protected boolean isClientRegion(@Nullable Object bean) {
        return bean instanceof CacheTypeAwareRegionFactoryBean || bean instanceof ClientRegionFactoryBean;
    }

    @NonNull
    protected Object configureAsLocalClientRegion(@NonNull Environment environment, @NonNull Object clientRegion) {
        return clientRegion instanceof ClientRegionFactoryBean ? this.configureAsLocalClientRegion(environment, (ClientRegionFactoryBean)clientRegion) : this.configureAsLocalClientRegion(environment, (CacheTypeAwareRegionFactoryBean)clientRegion);
    }

    @NonNull
    protected <K, V> CacheTypeAwareRegionFactoryBean<K, V> configureAsLocalClientRegion(@NonNull Environment environment, @NonNull CacheTypeAwareRegionFactoryBean<K, V> clientRegion) {
        ClientRegionShortcut shortcut = (ClientRegionShortcut)environment.getProperty("spring.data.gemfire.cache.client.region.shortcut", ClientRegionShortcut.class, (Object)ClusterAwareConfiguration.LOCAL_CLIENT_REGION_SHORTCUT);
        clientRegion.setClientRegionShortcut(shortcut);
        clientRegion.setPoolName("DEFAULT");
        return clientRegion;
    }

    @NonNull
    protected <K, V> ClientRegionFactoryBean<K, V> configureAsLocalClientRegion(@NonNull Environment environment, @NonNull ClientRegionFactoryBean<K, V> clientRegion) {
        ClientRegionShortcut shortcut = (ClientRegionShortcut)environment.getProperty("spring.data.gemfire.cache.client.region.shortcut", ClientRegionShortcut.class, (Object)ClusterAwareConfiguration.LOCAL_CLIENT_REGION_SHORTCUT);
        clientRegion.setPoolName(null);
        clientRegion.setShortcut(shortcut);
        return clientRegion;
    }

    public static final class NotKubernetesEnvironmentCondition
    implements Condition {
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            return !CloudPlatform.KUBERNETES.isActive(context.getEnvironment());
        }
    }

    public static final class NotCloudFoundryEnvironmentCondition
    implements Condition {
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            return !CloudPlatform.CLOUD_FOUNDRY.isActive(context.getEnvironment());
        }
    }

    public static final class ClusterNotAvailableCondition
    extends ClusterAwareConfiguration.ClusterAwareCondition {
        @Override
        public synchronized boolean matches(@NonNull ConditionContext conditionContext, @NonNull AnnotatedTypeMetadata typeMetadata) {
            return !super.matches(conditionContext, typeMetadata);
        }
    }

    public static final class AllClusterNotAvailableConditions
    extends AllNestedConditions {
        public AllClusterNotAvailableConditions() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @Conditional(value={NotKubernetesEnvironmentCondition.class})
        static class IsNotKubernetesEnvironmentCondition {
            IsNotKubernetesEnvironmentCondition() {
            }
        }

        @Conditional(value={NotCloudFoundryEnvironmentCondition.class})
        static class IsNotCloudFoundryEnvironmentCondition {
            IsNotCloudFoundryEnvironmentCondition() {
            }
        }

        @Conditional(value={ClusterNotAvailableCondition.class})
        static class IsClusterNotAvailableCondition {
            IsClusterNotAvailableCondition() {
            }
        }
    }
}

