/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import java.beans.ConstructorProperties;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;

class StandaloneConnectionProvider
implements LettuceConnectionProvider,
LettuceConnectionProvider.TargetAware {
    private final RedisClient client;
    private final RedisCodec<?, ?> codec;

    @Override
    public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
        if (connectionType.equals(StatefulRedisSentinelConnection.class)) {
            return (T)((StatefulConnection)connectionType.cast(this.client.connectSentinel()));
        }
        if (connectionType.equals(StatefulRedisPubSubConnection.class)) {
            return (T)((StatefulConnection)connectionType.cast(this.client.connectPubSub(this.codec)));
        }
        if (StatefulConnection.class.isAssignableFrom(connectionType)) {
            return (T)((StatefulConnection)connectionType.cast(this.client.connect(this.codec)));
        }
        throw new UnsupportedOperationException("Connection type " + connectionType + " not supported!");
    }

    @Override
    public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType, RedisURI redisURI) {
        if (connectionType.equals(StatefulRedisSentinelConnection.class)) {
            return (T)((StatefulConnection)connectionType.cast(this.client.connectSentinel(redisURI)));
        }
        if (connectionType.equals(StatefulRedisPubSubConnection.class)) {
            return (T)((StatefulConnection)connectionType.cast(this.client.connectPubSub(this.codec, redisURI)));
        }
        if (StatefulConnection.class.isAssignableFrom(connectionType)) {
            return (T)((StatefulConnection)connectionType.cast(this.client.connect(this.codec, redisURI)));
        }
        throw new UnsupportedOperationException("Connection type " + connectionType + " not supported!");
    }

    @ConstructorProperties(value={"client", "codec"})
    public StandaloneConnectionProvider(RedisClient client, RedisCodec<?, ?> codec) {
        this.client = client;
        this.codec = codec;
    }
}

