/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.convert.ListConverter;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.util.Assert;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.params.geo.GeoRadiusParam;

class JedisGeoCommands
implements RedisGeoCommands {
    @NonNull
    private final JedisConnection connection;

    @Override
    public Long geoAdd(byte[] key, Point point, byte[] member) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)point, (String)"Point must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().geoadd(key, point.getX(), point.getY(), member)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().geoadd(key, point.getX(), point.getY(), member)));
                return null;
            }
            return this.connection.getJedis().geoadd(key, point.getX(), point.getY(), member);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(memberCoordinateMap, (String)"MemberCoordinateMap must not be null!");
        HashMap<byte[], GeoCoordinate> redisGeoCoordinateMap = new HashMap<byte[], GeoCoordinate>();
        for (byte[] mapKey : memberCoordinateMap.keySet()) {
            redisGeoCoordinateMap.put(mapKey, JedisConverters.toGeoCoordinate(memberCoordinateMap.get(mapKey)));
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().geoadd(key, redisGeoCoordinateMap)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().geoadd(key, redisGeoCoordinateMap)));
                return null;
            }
            return this.connection.getJedis().geoadd(key, redisGeoCoordinateMap);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(locations, (String)"Locations must not be null!");
        HashMap<byte[], GeoCoordinate> redisGeoCoordinateMap = new HashMap<byte[], GeoCoordinate>();
        for (RedisGeoCommands.GeoLocation<byte[]> location : locations) {
            redisGeoCoordinateMap.put(location.getName(), JedisConverters.toGeoCoordinate(location.getPoint()));
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().geoadd(key, redisGeoCoordinateMap)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().geoadd(key, redisGeoCoordinateMap)));
                return null;
            }
            return this.connection.getJedis().geoadd(key, redisGeoCoordinateMap);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member1, (String)"Member1 must not be null!");
        Assert.notNull((Object)member2, (String)"Member2 must not be null!");
        Converter<Double, Distance> distanceConverter = JedisConverters.distanceConverterForMetric(RedisGeoCommands.DistanceUnit.METERS);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().geodist(key, member1, member2), distanceConverter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().geodist(key, member1, member2), distanceConverter));
                return null;
            }
            return (Distance)distanceConverter.convert((Object)this.connection.getJedis().geodist(key, member1, member2));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member1, (String)"Member1 must not be null!");
        Assert.notNull((Object)member2, (String)"Member2 must not be null!");
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(metric);
        Converter<Double, Distance> distanceConverter = JedisConverters.distanceConverterForMetric(metric);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().geodist(key, member1, member2, geoUnit), distanceConverter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().geodist(key, member1, member2, geoUnit), distanceConverter));
                return null;
            }
            return (Distance)distanceConverter.convert((Object)this.connection.getJedis().geodist(key, member1, member2, geoUnit));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<String> geoHash(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)members, (String)"Members must not be null!");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().geohash(key, members), JedisConverters.bytesListToStringListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().geohash(key, members), JedisConverters.bytesListToStringListConverter()));
                return null;
            }
            return JedisConverters.bytesListToStringListConverter().convert(this.connection.getJedis().geohash(key, members));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Point> geoPos(byte[] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)members, (String)"Members must not be null!");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null!");
        ListConverter<GeoCoordinate, Point> converter = JedisConverters.geoCoordinateToPointConverter();
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().geopos(key, members), converter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().geopos(key, members), converter));
                return null;
            }
            return converter.convert(this.connection.getJedis().geopos(key, members));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)within, (String)"Within must not be null!");
        Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = JedisConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric());
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().georadius(key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric())), converter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().georadius(key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric())), converter));
                return null;
            }
            return (GeoResults)converter.convert((Object)this.connection.getJedis().georadius(key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric())));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)within, (String)"Within must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        GeoRadiusParam geoRadiusParam = JedisConverters.toGeoRadiusParam(args);
        Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = JedisConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric());
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().georadius(key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric()), geoRadiusParam), converter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().georadius(key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric()), geoRadiusParam), converter));
                return null;
            }
            return (GeoResults)converter.convert((Object)this.connection.getJedis().georadius(key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), JedisConverters.toGeoUnit(within.getRadius().getMetric()), geoRadiusParam));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)radius, (String)"Radius must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(radius.getMetric());
        Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = JedisConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric());
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().georadiusByMember(key, member, radius.getValue(), geoUnit), converter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().georadiusByMember(key, member, radius.getValue(), geoUnit), converter));
                return null;
            }
            return (GeoResults)converter.convert((Object)this.connection.getJedis().georadiusByMember(key, member, radius.getValue(), geoUnit));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)member, (String)"Member must not be null!");
        Assert.notNull((Object)radius, (String)"Radius must not be null!");
        Assert.notNull((Object)args, (String)"Args must not be null!");
        GeoUnit geoUnit = JedisConverters.toGeoUnit(radius.getMetric());
        Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = JedisConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric());
        GeoRadiusParam geoRadiusParam = JedisConverters.toGeoRadiusParam(args);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().georadiusByMember(key, member, radius.getValue(), geoUnit, geoRadiusParam), converter));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().georadiusByMember(key, member, radius.getValue(), geoUnit, geoRadiusParam), converter));
                return null;
            }
            return (GeoResults)converter.convert((Object)this.connection.getJedis().georadiusByMember(key, member, radius.getValue(), geoUnit, geoRadiusParam));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long geoRemove(byte[] key, byte[] ... members) {
        return this.connection.zSetCommands().zRem(key, members);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisConnection.JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisConnection.JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    @ConstructorProperties(value={"connection"})
    public JedisGeoCommands(@NonNull JedisConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

