/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.data.authentication.UserCredentials;

public class CannotGetMongoDbConnectionException
extends DataAccessResourceFailureException {
    private final UserCredentials credentials;
    private final String database;
    private static final long serialVersionUID = 1172099106475265589L;

    public CannotGetMongoDbConnectionException(String msg, Throwable cause) {
        super(msg, cause);
        this.database = null;
        this.credentials = UserCredentials.NO_CREDENTIALS;
    }

    public CannotGetMongoDbConnectionException(String msg) {
        this(msg, null, UserCredentials.NO_CREDENTIALS);
    }

    public CannotGetMongoDbConnectionException(String msg, String database, UserCredentials credentials) {
        super(msg);
        this.database = database;
        this.credentials = credentials;
    }

    public UserCredentials getCredentials() {
        return this.credentials;
    }

    public String getDatabase() {
        return this.database;
    }
}

