/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.util.Assert;

public interface PersistentProperty<P extends PersistentProperty<P>> {
    public PersistentEntity<?, P> getOwner();

    public String getName();

    public Class<?> getType();

    public TypeInformation<?> getTypeInformation();

    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypeInformation();

    public @Nullable Method getGetter();

    default public Method getRequiredGetter() {
        Method getter = this.getGetter();
        if (getter == null) {
            throw new IllegalArgumentException(String.format("No getter available for persistent property %s", this));
        }
        return getter;
    }

    public @Nullable Method getSetter();

    default public Method getRequiredSetter() {
        Method setter = this.getSetter();
        if (setter == null) {
            throw new IllegalArgumentException(String.format("No setter available for persistent property %s", this));
        }
        return setter;
    }

    public @Nullable Method getWither();

    default public Method getRequiredWither() {
        Method wither = this.getWither();
        if (wither == null) {
            throw new IllegalArgumentException(String.format("No wither available for persistent property %s", this));
        }
        return wither;
    }

    public @Nullable Field getField();

    default public Field getRequiredField() {
        Field field = this.getField();
        if (field == null) {
            throw new IllegalArgumentException(String.format("No field backing persistent property %s", this));
        }
        return field;
    }

    public @Nullable String getSpelExpression();

    public @Nullable Association<P> getAssociation();

    default public Association<P> getRequiredAssociation() {
        Association<P> association = this.getAssociation();
        if (association != null) {
            return association;
        }
        throw new IllegalStateException("No association found");
    }

    public boolean isEntity();

    public boolean isIdProperty();

    public boolean isVersionProperty();

    public boolean isCollectionLike();

    public boolean isMap();

    public boolean isArray();

    public boolean isTransient();

    public boolean isWritable();

    public boolean isReadable();

    public boolean isImmutable();

    public boolean isAssociation();

    public @Nullable Class<?> getComponentType();

    public Class<?> getRawType();

    public @Nullable Class<?> getMapValueType();

    public Class<?> getActualType();

    public <A extends Annotation> @Nullable A findAnnotation(Class<A> var1);

    default public <A extends Annotation> A getRequiredAnnotation(Class<A> annotationType) throws IllegalStateException {
        A annotation = this.findAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        throw new IllegalStateException(String.format("Required annotation %s not found for %s", annotationType, this.getName()));
    }

    public <A extends Annotation> @Nullable A findPropertyOrOwnerAnnotation(Class<A> var1);

    public boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public boolean usePropertyAccess();

    default public boolean hasActualTypeAnnotation(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null");
        return AnnotatedElementUtils.hasAnnotation(this.getActualType(), annotationType);
    }

    public @Nullable Class<?> getAssociationTargetType();

    public @Nullable TypeInformation<?> getAssociationTargetTypeInformation();

    default public <T> PersistentPropertyAccessor<T> getAccessorForOwner(T owner) {
        Assert.notNull(owner, (String)"Owner must not be null");
        return this.getOwner().getPropertyAccessor(owner);
    }
}

