/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.AnnotationRepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultCrudMethods;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public abstract class AbstractRepositoryMetadata
implements RepositoryMetadata {
    private final TypeInformation<?> typeInformation;
    private final Class<?> repositoryInterface;
    private CrudMethods crudMethods;

    public AbstractRepositoryMetadata(Class<?> repositoryInterface) {
        Assert.notNull(repositoryInterface, (String)"Given type must not be null!");
        Assert.isTrue((boolean)repositoryInterface.isInterface(), (String)"Given type must be an interface!");
        this.repositoryInterface = repositoryInterface;
        this.typeInformation = ClassTypeInformation.from(repositoryInterface);
    }

    public static RepositoryMetadata getMetadata(Class<?> repositoryInterface) {
        Assert.notNull(repositoryInterface, (String)"Repository interface must not be null!");
        return Repository.class.isAssignableFrom(repositoryInterface) ? new DefaultRepositoryMetadata(repositoryInterface) : new AnnotationRepositoryMetadata(repositoryInterface);
    }

    @Override
    public Class<?> getReturnedDomainClass(Method method) {
        return AbstractRepositoryMetadata.unwrapWrapperTypes(this.typeInformation.getReturnType(method));
    }

    @Override
    public Class<?> getRepositoryInterface() {
        return this.repositoryInterface;
    }

    @Override
    public CrudMethods getCrudMethods() {
        if (this.crudMethods == null) {
            this.crudMethods = new DefaultCrudMethods(this);
        }
        return this.crudMethods;
    }

    @Override
    public boolean isPagingRepository() {
        Method findAllMethod = this.getCrudMethods().getFindAllMethod();
        if (findAllMethod == null) {
            return false;
        }
        return Arrays.asList(findAllMethod.getParameterTypes()).contains(Pageable.class);
    }

    private static Class<?> unwrapWrapperTypes(TypeInformation<?> type) {
        Class<?> rawType = type.getType();
        boolean needToUnwrap = Iterable.class.isAssignableFrom(rawType) || rawType.isArray() || QueryExecutionConverters.supports(rawType);
        return needToUnwrap ? AbstractRepositoryMetadata.unwrapWrapperTypes(type.getComponentType()) : rawType;
    }
}

