/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.scheduling;

import java.util.regex.Pattern;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.scheduling.SleuthSchedulingSpan;
import org.springframework.cloud.sleuth.internal.SpanNameUtil;
import org.springframework.lang.Nullable;

@Aspect
public class TraceSchedulingAspect {
    private final Tracer tracer;
    @Nullable
    private final Pattern skipPattern;

    public TraceSchedulingAspect(Tracer tracer, Pattern skipPattern) {
        this.tracer = tracer;
        this.skipPattern = skipPattern;
    }

    @Around(value="execution (@org.springframework.scheduling.annotation.Scheduled  * *.*(..))")
    public Object traceBackgroundThread(ProceedingJoinPoint pjp) throws Throwable {
        if (this.skipPattern != null && this.skipPattern.matcher(pjp.getTarget().getClass().getName()).matches()) {
            this.tracer.withSpan(null);
            return pjp.proceed();
        }
        String spanName = SpanNameUtil.toLowerHyphen(pjp.getSignature().getName());
        AssertingSpan span = SleuthSchedulingSpan.SCHEDULED_ANNOTATION_SPAN.wrap(this.startOrContinueSpan()).name(spanName);
        try {
            Object object;
            block12: {
                Tracer.SpanInScope ws = this.tracer.withSpan((Span)span.start());
                try {
                    span.tag((TagKey)SleuthSchedulingSpan.Tags.CLASS, pjp.getTarget().getClass().getSimpleName()).tag((TagKey)SleuthSchedulingSpan.Tags.METHOD, pjp.getSignature().getName());
                    object = pjp.proceed();
                    if (ws == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable ex) {
                        span.error(ex);
                        throw ex;
                    }
                }
                ws.close();
            }
            return object;
        }
        finally {
            span.end();
        }
    }

    private Span startOrContinueSpan() {
        Span currentSpan = this.tracer.currentSpan();
        if (currentSpan != null) {
            return currentSpan;
        }
        return SleuthSchedulingSpan.SCHEDULED_ANNOTATION_SPAN.wrap(this.tracer.nextSpan());
    }
}

