/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.session;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.session.TraceSessionRepositoryAspect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.SessionRepository;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SessionRepository.class})
@ConditionalOnProperty(value={"spring.sleuth.session.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class TraceSessionAutoConfiguration {
    @Bean
    TraceSessionRepositoryAspect traceSessionRepositoryAspect(Tracer tracer, CurrentTraceContext currentTraceContext) {
        return new TraceSessionRepositoryAspect(tracer, currentTraceContext);
    }
}

