/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.async;

import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.async.ExecutorBeanPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.async.SleuthAsyncProperties;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceExecutor;
import org.springframework.cloud.sleuth.instrument.async.TraceAsyncAspect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SleuthAsyncProperties.class})
@ConditionalOnProperty(value={"spring.sleuth.async.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class TraceAsyncDefaultAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.sleuth.scheduled.enabled"}, matchIfMissing=true)
    static ExecutorBeanPostProcessor executorBeanPostProcessor(BeanFactory beanFactory) {
        return new ExecutorBeanPostProcessor(beanFactory);
    }

    @Bean
    TraceAsyncAspect traceAsyncAspect(Tracer tracer, SpanNamer spanNamer) {
        return new TraceAsyncAspect(tracer, spanNamer);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={AsyncConfigurer.class})
    @ConditionalOnMissingBean(value={AsyncConfigurer.class})
    @ConditionalOnProperty(value={"spring.sleuth.async.configurer.enabled"}, matchIfMissing=true)
    @Role(value=2)
    static class DefaultAsyncConfigurerSupport
    extends AsyncConfigurerSupport {
        private static final Log log = LogFactory.getLog(DefaultAsyncConfigurerSupport.class);
        @Autowired
        private BeanFactory beanFactory;

        DefaultAsyncConfigurerSupport() {
        }

        public Executor getAsyncExecutor() {
            Executor delegate = this.getDefaultExecutor();
            return LazyTraceExecutor.wrap((BeanFactory)this.beanFactory, (Executor)delegate);
        }

        private Executor getDefaultExecutor() {
            try {
                return (Executor)this.beanFactory.getBean(TaskExecutor.class);
            }
            catch (NoUniqueBeanDefinitionException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Could not find unique TaskExecutor bean", (Throwable)ex);
                }
                try {
                    return (Executor)this.beanFactory.getBean("taskExecutor", Executor.class);
                }
                catch (NoSuchBeanDefinitionException ex2) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("More than one TaskExecutor bean found within the context, and none is named 'taskExecutor'. Mark one of them as primary or name it 'taskExecutor' (possibly as an alias) in order to use it for async processing: " + ex.getBeanNamesFound()));
                    }
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                log.debug((Object)"Could not find default TaskExecutor bean", (Throwable)ex);
                try {
                    return (Executor)this.beanFactory.getBean("taskExecutor", Executor.class);
                }
                catch (NoSuchBeanDefinitionException ex2) {
                    log.info((Object)"No task executor bean found for async processing: no bean of type TaskExecutor and no bean named 'taskExecutor' either");
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"For backward compatibility, will fallback to the default, SimpleAsyncTaskExecutor implementation");
            }
            return new SimpleAsyncTaskExecutor();
        }
    }
}

