/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave.instrument.messaging;

import brave.Tracing;
import brave.kafka.clients.KafkaTracing;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.KafkaStreams;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.brave.instrument.messaging.KafkaStreamsBuilderFactoryBeanPostProcessor;
import org.springframework.cloud.sleuth.brave.instrument.messaging.ConditionalOnMessagingEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMessagingEnabled
@ConditionalOnBean(value={Tracing.class})
@ConditionalOnProperty(value={"spring.sleuth.messaging.kafka.streams.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={KafkaStreams.class, KafkaTracing.class, StreamsBuilderFactoryBean.class})
class BraveKafkaStreamsAutoConfiguration {
    protected BraveKafkaStreamsAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    static KafkaStreamsTracing kafkaStreamsTracing(Tracing tracing) {
        return KafkaStreamsTracing.create((Tracing)tracing);
    }

    @Bean
    static KafkaStreamsBuilderFactoryBeanPostProcessor kafkaStreamsBuilderFactoryBeanPostProcessor(ObjectProvider<KafkaStreamsTracing> objectProvider) {
        return new KafkaStreamsBuilderFactoryBeanPostProcessor(objectProvider);
    }
}

