/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure.actuate.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.webmvc.error.DefaultErrorAttributes;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;

class CompositeHandlerExceptionResolver
implements HandlerExceptionResolver {
    @Autowired
    private ListableBeanFactory beanFactory;
    private volatile @Nullable List<HandlerExceptionResolver> resolvers;

    CompositeHandlerExceptionResolver() {
    }

    public @Nullable ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) {
        for (HandlerExceptionResolver resolver : this.getResolvers()) {
            ModelAndView resolved = resolver.resolveException(request, response, handler, ex);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    private List<HandlerExceptionResolver> getResolvers() {
        List<HandlerExceptionResolver> resolvers = this.resolvers;
        if (resolvers == null) {
            resolvers = new ArrayList<HandlerExceptionResolver>();
            this.collectResolverBeans(resolvers, (BeanFactory)this.beanFactory);
            resolvers.remove(this);
            AnnotationAwareOrderComparator.sort(resolvers);
            if (resolvers.isEmpty()) {
                resolvers.add(new DefaultErrorAttributes());
                resolvers.add((HandlerExceptionResolver)new DefaultHandlerExceptionResolver());
            }
            this.resolvers = resolvers;
        }
        return resolvers;
    }

    private void collectResolverBeans(List<HandlerExceptionResolver> resolvers, @Nullable BeanFactory beanFactory) {
        if (beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)beanFactory;
            resolvers.addAll(listableBeanFactory.getBeansOfType(HandlerExceptionResolver.class).values());
        }
        if (beanFactory instanceof HierarchicalBeanFactory) {
            HierarchicalBeanFactory hierarchicalBeanFactory = (HierarchicalBeanFactory)beanFactory;
            this.collectResolverBeans(resolvers, hierarchicalBeanFactory.getParentBeanFactory());
        }
    }
}

