/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.oauth2.client.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.security.oauth2.client.autoconfigure.OAuth2ClientConfigurations;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.security.oauth2.client.registration.ClientRegistration;

@AutoConfiguration
@Conditional(value={NonReactiveWebApplicationCondition.class})
@ConditionalOnClass(value={ClientRegistration.class})
@Import(value={OAuth2ClientConfigurations.ClientRegistrationRepositoryConfiguration.class, OAuth2ClientConfigurations.OAuth2AuthorizedClientServiceConfiguration.class})
public final class OAuth2ClientAutoConfiguration {

    static class NonReactiveWebApplicationCondition
    extends NoneNestedConditions {
        NonReactiveWebApplicationCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
        static class ReactiveWebApplicationCondition {
            ReactiveWebApplicationCondition() {
            }
        }
    }
}

