/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import com.sun.jna.Platform;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.Socket;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import org.apache.hc.client5.http.io.DetachedSocketFactory;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.configuration.ResolvedDockerHost;
import org.springframework.boot.buildpack.platform.docker.transport.HttpClientTransport;
import org.springframework.boot.buildpack.platform.socket.NamedPipeSocket;
import org.springframework.boot.buildpack.platform.socket.UnixDomainSocket;

final class LocalHttpClientTransport
extends HttpClientTransport {
    private static final String DOCKER_SCHEME = "docker";
    private static final int DEFAULT_DOCKER_PORT = 2376;
    private static final HttpHost LOCAL_DOCKER_HOST = new HttpHost("docker", "localhost", 2376);

    private LocalHttpClientTransport(HttpClient client, HttpHost host) {
        super(client, host);
    }

    @Override
    protected void beforeExecute(HttpRequest request) {
        request.setHeader("Host", (Object)LOCAL_DOCKER_HOST.toHostString());
    }

    static LocalHttpClientTransport create(ResolvedDockerHost dockerHost) {
        HttpClientBuilder builder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new LocalConnectionManager(dockerHost)).setRoutePlanner((HttpRoutePlanner)new LocalRoutePlanner());
        HttpHost host = new HttpHost(DOCKER_SCHEME, dockerHost.getAddress());
        return new LocalHttpClientTransport((HttpClient)builder.build(), host);
    }

    private static class LocalConnectionManager
    extends BasicHttpClientConnectionManager {
        private static final ConnectionConfig CONNECTION_CONFIG = ConnectionConfig.copy((ConnectionConfig)ConnectionConfig.DEFAULT).setValidateAfterInactivity(TimeValue.NEG_ONE_MILLISECOND).build();
        private static final Lookup<@Nullable TlsSocketStrategy> NO_TLS_SOCKET = name -> null;

        LocalConnectionManager(ResolvedDockerHost dockerHost) {
            super((HttpClientConnectionOperator)LocalConnectionManager.createHttpClientConnectionOperator(dockerHost), null);
            this.setConnectionConfig(CONNECTION_CONFIG);
        }

        private static DefaultHttpClientConnectionOperator createHttpClientConnectionOperator(ResolvedDockerHost dockerHost) {
            LocalDetachedSocketFactory detachedSocketFactory = new LocalDetachedSocketFactory(dockerHost);
            LocalDnsResolver dnsResolver = new LocalDnsResolver();
            return new DefaultHttpClientConnectionOperator((DetachedSocketFactory)detachedSocketFactory, null, (DnsResolver)dnsResolver, NO_TLS_SOCKET);
        }
    }

    private static final class LocalRoutePlanner
    implements HttpRoutePlanner {
        private LocalRoutePlanner() {
        }

        public HttpRoute determineRoute(HttpHost target, HttpContext context) {
            return new HttpRoute(LOCAL_DOCKER_HOST);
        }
    }

    private static final class LocalDnsResolver
    implements DnsResolver {
        private static final InetAddress LOOPBACK = InetAddress.getLoopbackAddress();

        private LocalDnsResolver() {
        }

        public InetAddress[] resolve(String host) {
            return new InetAddress[]{LOOPBACK};
        }

        public String resolveCanonicalHostname(String host) {
            return LOOPBACK.getCanonicalHostName();
        }
    }

    static class LocalDetachedSocketFactory
    implements DetachedSocketFactory {
        private static final String NPIPE_PREFIX = "npipe://";
        private final ResolvedDockerHost dockerHost;

        LocalDetachedSocketFactory(ResolvedDockerHost dockerHost) {
            this.dockerHost = dockerHost;
        }

        public Socket create(Proxy proxy) throws IOException {
            String address = this.dockerHost.getAddress();
            if (address.startsWith(NPIPE_PREFIX)) {
                return NamedPipeSocket.get(address.substring(NPIPE_PREFIX.length()));
            }
            return !Platform.isWindows() ? UnixDomainSocket.get(address) : NamedPipeSocket.get(address);
        }
    }
}

