/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.health.AutoConfiguredHealthContributorRegistry;
import org.springframework.boot.actuate.autoconfigure.health.AutoConfiguredHealthEndpointGroups;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.CompositeReactiveHealthContributor;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HealthEndpointGroupsPostProcessor;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.NamedContributor;
import org.springframework.boot.actuate.health.NamedContributors;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.actuate.health.SimpleHttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleStatusAggregator;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
class HealthEndpointConfiguration {
    HealthEndpointConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    StatusAggregator healthStatusAggregator(HealthEndpointProperties properties) {
        return new SimpleStatusAggregator(properties.getStatus().getOrder());
    }

    @Bean
    @ConditionalOnMissingBean
    HttpCodeStatusMapper healthHttpCodeStatusMapper(HealthEndpointProperties properties) {
        return new SimpleHttpCodeStatusMapper(properties.getStatus().getHttpMapping());
    }

    @Bean
    @ConditionalOnMissingBean(value={HealthEndpointGroups.class})
    AutoConfiguredHealthEndpointGroups healthEndpointGroups(ApplicationContext applicationContext, HealthEndpointProperties properties) {
        return new AutoConfiguredHealthEndpointGroups(applicationContext, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    HealthContributorRegistry healthContributorRegistry(ApplicationContext applicationContext, HealthEndpointGroups groups, Map<String, HealthContributor> healthContributors, Map<String, ReactiveHealthContributor> reactiveHealthContributors) {
        if (ClassUtils.isPresent((String)"reactor.core.publisher.Flux", (ClassLoader)applicationContext.getClassLoader())) {
            healthContributors.putAll(new AdaptedReactiveHealthContributors(reactiveHealthContributors).get());
        }
        return new AutoConfiguredHealthContributorRegistry(healthContributors, groups.getNames());
    }

    @Bean
    @ConditionalOnProperty(name={"management.endpoint.health.validate-group-membership"}, havingValue="true", matchIfMissing=true)
    HealthEndpointGroupMembershipValidator healthEndpointGroupMembershipValidator(HealthEndpointProperties properties, HealthContributorRegistry healthContributorRegistry) {
        return new HealthEndpointGroupMembershipValidator(properties, healthContributorRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    HealthEndpoint healthEndpoint(HealthContributorRegistry registry, HealthEndpointGroups groups, HealthEndpointProperties properties) {
        return new HealthEndpoint(registry, groups, properties.getLogging().getSlowIndicatorThreshold());
    }

    @Bean
    static HealthEndpointGroupsBeanPostProcessor healthEndpointGroupsBeanPostProcessor(ObjectProvider<HealthEndpointGroupsPostProcessor> healthEndpointGroupsPostProcessors) {
        return new HealthEndpointGroupsBeanPostProcessor(healthEndpointGroupsPostProcessors);
    }

    private static class AdaptedReactiveHealthContributors {
        private final Map<String, HealthContributor> adapted;

        AdaptedReactiveHealthContributors(Map<String, ReactiveHealthContributor> reactiveContributors) {
            LinkedHashMap adapted = new LinkedHashMap();
            reactiveContributors.forEach((name, contributor) -> adapted.put(name, this.adapt((ReactiveHealthContributor)contributor)));
            this.adapted = Collections.unmodifiableMap(adapted);
        }

        private HealthContributor adapt(ReactiveHealthContributor contributor) {
            if (contributor instanceof ReactiveHealthIndicator) {
                ReactiveHealthIndicator healthIndicator = (ReactiveHealthIndicator)contributor;
                return this.adapt(healthIndicator);
            }
            if (contributor instanceof CompositeReactiveHealthContributor) {
                CompositeReactiveHealthContributor healthContributor = (CompositeReactiveHealthContributor)contributor;
                return this.adapt(healthContributor);
            }
            throw new IllegalStateException("Unsupported ReactiveHealthContributor type " + contributor.getClass());
        }

        private HealthIndicator adapt(final ReactiveHealthIndicator indicator) {
            return new HealthIndicator(){

                public Health getHealth(boolean includeDetails) {
                    return (Health)indicator.getHealth(includeDetails).block();
                }

                public Health health() {
                    return (Health)indicator.health().block();
                }
            };
        }

        private CompositeHealthContributor adapt(final CompositeReactiveHealthContributor composite) {
            return new CompositeHealthContributor(){

                public Iterator<NamedContributor<HealthContributor>> iterator() {
                    final Iterator iterator = composite.iterator();
                    return new Iterator<NamedContributor<HealthContributor>>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public NamedContributor<HealthContributor> next() {
                            NamedContributor next = (NamedContributor)iterator.next();
                            return NamedContributor.of((String)next.getName(), (Object)this.adapt((ReactiveHealthContributor)next.getContributor()));
                        }
                    };
                }

                public HealthContributor getContributor(String name) {
                    return this.adapt((ReactiveHealthContributor)composite.getContributor(name));
                }
            };
        }

        Map<String, HealthContributor> get() {
            return this.adapted;
        }
    }

    static class HealthEndpointGroupMembershipValidator
    implements SmartInitializingSingleton {
        private final HealthEndpointProperties properties;
        private final HealthContributorRegistry registry;

        HealthEndpointGroupMembershipValidator(HealthEndpointProperties properties, HealthContributorRegistry registry) {
            this.properties = properties;
            this.registry = registry;
        }

        public void afterSingletonsInstantiated() {
            this.validateGroups();
        }

        private void validateGroups() {
            this.properties.getGroup().forEach((name, group) -> {
                this.validate(group.getInclude(), "Included", (String)name);
                this.validate(group.getExclude(), "Excluded", (String)name);
            });
        }

        private void validate(Set<String> names, String type, String group) {
            if (CollectionUtils.isEmpty(names)) {
                return;
            }
            for (String name : names) {
                if ("*".equals(name)) {
                    return;
                }
                String[] path = name.split("/");
                if (this.contributorExists(path)) continue;
                throw new NoSuchHealthContributorException(type, name, group);
            }
        }

        private boolean contributorExists(String[] path) {
            Object contributor = this.registry;
            for (int pathOffset = 0; pathOffset < path.length; ++pathOffset) {
                if (!(contributor instanceof NamedContributors)) {
                    return false;
                }
                contributor = ((NamedContributors)contributor).getContributor(path[pathOffset]);
            }
            return contributor != null;
        }

        static class NoSuchHealthContributorException
        extends RuntimeException {
            NoSuchHealthContributorException(String type, String name, String group) {
                super(type + " health contributor '" + name + "' in group '" + group + "' does not exist");
            }
        }
    }

    static class HealthEndpointGroupsBeanPostProcessor
    implements BeanPostProcessor {
        private final ObjectProvider<HealthEndpointGroupsPostProcessor> postProcessors;

        HealthEndpointGroupsBeanPostProcessor(ObjectProvider<HealthEndpointGroupsPostProcessor> postProcessors) {
            this.postProcessors = postProcessors;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof HealthEndpointGroups) {
                HealthEndpointGroups groups = (HealthEndpointGroups)bean;
                return this.applyPostProcessors(groups);
            }
            return bean;
        }

        private Object applyPostProcessors(HealthEndpointGroups bean) {
            for (HealthEndpointGroupsPostProcessor postProcessor : (HealthEndpointGroupsPostProcessor[])this.postProcessors.orderedStream().toArray(HealthEndpointGroupsPostProcessor[]::new)) {
                bean = postProcessor.postProcessHealthEndpointGroups(bean);
            }
            return bean;
        }
    }
}

