/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConfigurationProperties(prefix="springdoc")
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class SpringDocConfigProperties {
    private boolean showActuator;
    private Webjars webjars = new Webjars();
    private ApiDocs apiDocs = new ApiDocs();
    private List<String> packagesToScan;
    private List<String> packagesToExclude;
    private List<String> pathsToMatch;
    private List<String> pathsToExclude;
    private Cache cache = new Cache();
    private List<GroupConfig> groupConfigs = new ArrayList<GroupConfig>();
    private boolean autoTagClasses = true;
    private boolean modelAndViewAllowed;
    private boolean overrideWithGenericResponse = true;
    private boolean removeBrokenReferenceDefinitions = true;
    private boolean writerWithDefaultPrettyPrinter;
    private String defaultConsumesMediaType = "application/json";
    private String defaultProducesMediaType = "*/*";
    private boolean useFqn;
    private boolean showLoginEndpoint;

    public boolean isUseFqn() {
        return this.useFqn;
    }

    public void setUseFqn(boolean useFqn) {
        this.useFqn = useFqn;
    }

    public boolean isAutoTagClasses() {
        return this.autoTagClasses;
    }

    public void setAutoTagClasses(boolean autoTagClasses) {
        this.autoTagClasses = autoTagClasses;
    }

    public boolean isModelAndViewAllowed() {
        return this.modelAndViewAllowed;
    }

    public void setModelAndViewAllowed(boolean modelAndViewAllowed) {
        this.modelAndViewAllowed = modelAndViewAllowed;
    }

    public List<String> getPackagesToExclude() {
        return this.packagesToExclude;
    }

    public void setPackagesToExclude(List<String> packagesToExclude) {
        this.packagesToExclude = packagesToExclude;
    }

    public List<String> getPathsToExclude() {
        return this.pathsToExclude;
    }

    public void setPathsToExclude(List<String> pathsToExclude) {
        this.pathsToExclude = pathsToExclude;
    }

    public boolean isShowLoginEndpoint() {
        return this.showLoginEndpoint;
    }

    public void setShowLoginEndpoint(boolean showLoginEndpoint) {
        this.showLoginEndpoint = showLoginEndpoint;
    }

    public List<String> getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setPackagesToScan(List<String> packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public boolean isShowActuator() {
        return this.showActuator;
    }

    public void setShowActuator(boolean showActuator) {
        this.showActuator = showActuator;
    }

    public Webjars getWebjars() {
        return this.webjars;
    }

    public void setWebjars(Webjars webjars) {
        this.webjars = webjars;
    }

    public ApiDocs getApiDocs() {
        return this.apiDocs;
    }

    public void setApiDocs(ApiDocs apiDocs) {
        this.apiDocs = apiDocs;
    }

    public List<String> getPathsToMatch() {
        return this.pathsToMatch;
    }

    public void setPathsToMatch(List<String> pathsToMatch) {
        this.pathsToMatch = pathsToMatch;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public boolean isCacheDisabled() {
        return this.cache.isDisabled();
    }

    public List<GroupConfig> getGroupConfigs() {
        return this.groupConfigs;
    }

    public void setGroupConfigs(List<GroupConfig> groupConfigs) {
        this.groupConfigs = groupConfigs;
    }

    public void addGroupConfig(GroupConfig groupConfigs) {
        this.groupConfigs.add(groupConfigs);
    }

    public String getDefaultConsumesMediaType() {
        return this.defaultConsumesMediaType;
    }

    public void setDefaultConsumesMediaType(String defaultConsumesMediaType) {
        this.defaultConsumesMediaType = defaultConsumesMediaType;
    }

    public String getDefaultProducesMediaType() {
        return this.defaultProducesMediaType;
    }

    public void setDefaultProducesMediaType(String defaultProducesMediaType) {
        this.defaultProducesMediaType = defaultProducesMediaType;
    }

    public boolean isOverrideWithGenericResponse() {
        return this.overrideWithGenericResponse;
    }

    public void setOverrideWithGenericResponse(boolean overrideWithGenericResponse) {
        this.overrideWithGenericResponse = overrideWithGenericResponse;
    }

    public boolean isRemoveBrokenReferenceDefinitions() {
        return this.removeBrokenReferenceDefinitions;
    }

    public void setRemoveBrokenReferenceDefinitions(boolean removeBrokenReferenceDefinitions) {
        this.removeBrokenReferenceDefinitions = removeBrokenReferenceDefinitions;
    }

    public boolean isWriterWithDefaultPrettyPrinter() {
        return this.writerWithDefaultPrettyPrinter;
    }

    public void setWriterWithDefaultPrettyPrinter(boolean writerWithDefaultPrettyPrinter) {
        this.writerWithDefaultPrettyPrinter = writerWithDefaultPrettyPrinter;
    }

    public static class GroupConfig {
        private List<String> pathsToMatch;
        private List<String> packagesToScan;
        private List<String> packagesToExclude;
        private List<String> pathsToExclude;
        private String group;

        public GroupConfig() {
        }

        public GroupConfig(String group, List<String> pathsToMatch, List<String> packagesToScan, List<String> packagesToExclude, List<String> pathsToExclude) {
            this.pathsToMatch = pathsToMatch;
            this.pathsToExclude = pathsToExclude;
            this.packagesToExclude = packagesToExclude;
            this.packagesToScan = packagesToScan;
            this.group = group;
        }

        public List<String> getPathsToMatch() {
            return this.pathsToMatch;
        }

        public void setPathsToMatch(List<String> pathsToMatch) {
            this.pathsToMatch = pathsToMatch;
        }

        public List<String> getPackagesToScan() {
            return this.packagesToScan;
        }

        public void setPackagesToScan(List<String> packagesToScan) {
            this.packagesToScan = packagesToScan;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public List<String> getPackagesToExclude() {
            return this.packagesToExclude;
        }

        public void setPackagesToExclude(List<String> packagesToExclude) {
            this.packagesToExclude = packagesToExclude;
        }

        public List<String> getPathsToExclude() {
            return this.pathsToExclude;
        }

        public void setPathsToExclude(List<String> pathsToExclude) {
            this.pathsToExclude = pathsToExclude;
        }
    }

    public static class Cache {
        private boolean disabled;

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }
    }

    public static class Groups {
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class ApiDocs {
        private String path = "/v3/api-docs";
        private boolean enabled = true;
        private boolean resolveSchemaProperties;
        private Groups groups = new Groups();

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Groups getGroups() {
            return this.groups;
        }

        public void setGroups(Groups groups) {
            this.groups = groups;
        }

        public boolean isResolveSchemaProperties() {
            return this.resolveSchemaProperties;
        }

        public void setResolveSchemaProperties(boolean resolveSchemaProperties) {
            this.resolveSchemaProperties = resolveSchemaProperties;
        }
    }

    public static class Webjars {
        private String prefix = "/webjars";

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    public static class ModelConverters {
        private DeprecatingConverter deprecatingConverter = new DeprecatingConverter();

        public DeprecatingConverter getDeprecatingConverter() {
            return this.deprecatingConverter;
        }

        public void setDeprecatingConverter(DeprecatingConverter deprecatingConverter) {
            this.deprecatingConverter = deprecatingConverter;
        }

        public static class DeprecatingConverter {
            private boolean enabled;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }
}

