/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateSubColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateSubColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateSubScalarCol;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="date_sub", value="_FUNC_(start_date, num_days) - Returns the date that is num_days before start_date.", extended="start_date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. num_days is a number. The time part of start_date is ignored.\nExample:\n   > SELECT _FUNC_('2009-07-30', 1) FROM src LIMIT 1;\n  '2009-07-29'")
@VectorizedExpressions(value={VectorUDFDateSubColScalar.class, VectorUDFDateSubScalarCol.class, VectorUDFDateSubColCol.class})
public class GenericUDFDateSub
extends GenericUDF {
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private transient ObjectInspectorConverters.Converter dateConverter;
    private transient ObjectInspectorConverters.Converter daysConverter;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType1;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType2;
    private final Calendar calendar = Calendar.getInstance();
    private final Text output = new Text();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("date_sub() requires 2 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + arguments[0].getTypeName() + " is passed. as first arguments");
        }
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + arguments[1].getTypeName() + " is passed. as second arguments");
        }
        this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        switch (this.inputType1) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                this.inputType1 = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                this.dateConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[0]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                break;
            }
            case TIMESTAMP: {
                this.dateConverter = new PrimitiveObjectInspectorConverter.TimestampConverter((PrimitiveObjectInspector)arguments[0], PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                break;
            }
            case DATE: {
                this.dateConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[0]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException("DATE_SUB() only takes STRING/TIMESTAMP/DATEWRITABLE types as first argument, got " + (Object)((Object)this.inputType1));
            }
        }
        this.inputType2 = ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory();
        switch (this.inputType2) {
            case BYTE: {
                this.daysConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[1]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableByteObjectInspector);
                break;
            }
            case SHORT: {
                this.daysConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[1]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableShortObjectInspector);
                break;
            }
            case INT: {
                this.daysConverter = ObjectInspectorConverters.getConverter((ObjectInspector)((PrimitiveObjectInspector)arguments[1]), (ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentException(" DATE_ADD() only takes TINYINT/SMALLINT/INT/BIGINT types as second argument, got " + (Object)((Object)this.inputType2));
            }
        }
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int toBeSubed;
        if (arguments[0].get() == null) {
            return null;
        }
        Object daysWritableObject = this.daysConverter.convert(arguments[1].get());
        if (daysWritableObject == null) {
            return null;
        }
        if (daysWritableObject instanceof ByteWritable) {
            toBeSubed = ((ByteWritable)((Object)daysWritableObject)).get();
        } else if (daysWritableObject instanceof ShortWritable) {
            toBeSubed = ((ShortWritable)daysWritableObject).get();
        } else if (daysWritableObject instanceof IntWritable) {
            toBeSubed = ((IntWritable)daysWritableObject).get();
        } else {
            return null;
        }
        switch (this.inputType1) {
            case STRING: {
                String dateString = this.dateConverter.convert(arguments[0].get()).toString();
                try {
                    this.calendar.setTime(this.formatter.parse(dateString.toString()));
                    break;
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampWritable)this.dateConverter.convert(arguments[0].get())).getTimestamp();
                this.calendar.setTime(ts);
                break;
            }
            case DATE: {
                DateWritable dw = (DateWritable)this.dateConverter.convert(arguments[0].get());
                this.calendar.setTime(dw.get());
                break;
            }
            default: {
                throw new UDFArgumentException("DATE_SUB() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + (Object)((Object)this.inputType1));
            }
        }
        this.calendar.add(5, -toBeSubed);
        Date newDate = this.calendar.getTime();
        this.output.set(this.formatter.format(newDate));
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("date_sub", children);
    }
}

