/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStreamingEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

@WindowFunctionDescription(description=@Description(name="last_value", value="_FUNC_(x)"), supportsWindow=true, pivotResult=false, impliesOrder=true)
public class GenericUDAFLastValue
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)GenericUDAFLastValue.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length > 2) {
            throw new UDFArgumentTypeException(2, "At most 2 arguments expected");
        }
        if (parameters.length > 1 && !parameters[1].equals(TypeInfoFactory.booleanTypeInfo)) {
            throw new UDFArgumentTypeException(1, "second argument must be a boolean expression");
        }
        return this.createEvaluator();
    }

    protected GenericUDAFLastValueEvaluator createEvaluator() {
        return new GenericUDAFLastValueEvaluator();
    }

    static class LastValStreamingFixedWindow
    extends GenericUDAFStreamingEvaluator<Object> {
        public LastValStreamingFixedWindow(GenericUDAFEvaluator wrappedEval, int numPreceding, int numFollowing) {
            super(wrappedEval, numPreceding, numFollowing);
        }

        @Override
        public int getRowsRemainingAfterTerminate() throws HiveException {
            throw new UnsupportedOperationException();
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFEvaluator.AggregationBuffer underlying = this.wrappedEval.getNewAggregationBuffer();
            return new State(this.numPreceding, this.numFollowing, underlying);
        }

        protected ObjectInspector inputOI() {
            return ((GenericUDAFLastValueEvaluator)this.wrappedEval).inputOI;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            State s = (State)agg;
            LastValueBuffer lb = (LastValueBuffer)s.wrappedBuf;
            if (lb.firstRow) {
                this.wrappedEval.iterate(lb, parameters);
            }
            Object o = ObjectInspectorUtils.copyToStandardObject(parameters[0], this.inputOI(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            if (!lb.skipNulls || o != null) {
                s.lastValue = o;
                s.lastIdx = s.numRows;
            } else if (lb.skipNulls && s.lastIdx != -1 && s.numPreceding != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT && s.numRows > s.lastIdx + s.numPreceding + s.numFollowing) {
                s.lastValue = null;
                s.lastIdx = -1;
            }
            if (s.numRows >= s.numFollowing) {
                s.results.add(s.lastValue);
            }
            ++s.numRows;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            State s = (State)agg;
            LastValueBuffer lb = (LastValueBuffer)s.wrappedBuf;
            if (lb.skipNulls && s.lastIdx != -1 && s.numPreceding != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT && s.numRows > s.lastIdx + s.numPreceding + s.numFollowing) {
                s.lastValue = null;
                s.lastIdx = -1;
            }
            for (int i = 0; i < s.numFollowing; ++i) {
                s.results.add(s.lastValue);
            }
            return null;
        }

        class State
        extends GenericUDAFStreamingEvaluator.StreamingState {
            private Object lastValue;
            private int lastIdx;

            public State(int numPreceding, int numFollowing, GenericUDAFEvaluator.AggregationBuffer buf) {
                super(LastValStreamingFixedWindow.this, numPreceding, numFollowing, buf);
                this.lastValue = null;
                this.lastIdx = -1;
            }

            @Override
            public int estimate() {
                if (!(this.wrappedBuf instanceof GenericUDAFEvaluator.AbstractAggregationBuffer)) {
                    return -1;
                }
                int underlying = ((GenericUDAFEvaluator.AbstractAggregationBuffer)this.wrappedBuf).estimate();
                if (underlying == -1) {
                    return -1;
                }
                return 2 * underlying;
            }

            @Override
            protected void reset() {
                this.lastValue = null;
                this.lastIdx = -1;
                super.reset();
            }
        }
    }

    public static class GenericUDAFLastValueEvaluator
    extends GenericUDAFEvaluator {
        ObjectInspector inputOI;
        ObjectInspector outputOI;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m != GenericUDAFEvaluator.Mode.COMPLETE) {
                throw new HiveException("Only COMPLETE mode supported for Rank function");
            }
            this.inputOI = parameters[0];
            this.outputOI = ObjectInspectorUtils.getStandardObjectInspector(this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            return this.outputOI;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new LastValueBuffer();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((LastValueBuffer)agg).init();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            LastValueBuffer lb = (LastValueBuffer)agg;
            if (lb.firstRow) {
                lb.firstRow = false;
                if (parameters.length == 2) {
                    lb.skipNulls = PrimitiveObjectInspectorUtils.getBoolean(parameters[1], PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
                }
            }
            Object o = ObjectInspectorUtils.copyToStandardObject(parameters[0], this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            if (!lb.skipNulls || o != null) {
                lb.val = o;
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            throw new HiveException("terminatePartial not supported");
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            throw new HiveException("merge not supported");
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            LastValueBuffer lb = (LastValueBuffer)agg;
            return lb.val;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            BoundaryDef start = wFrmDef.getStart();
            BoundaryDef end = wFrmDef.getEnd();
            return new LastValStreamingFixedWindow(this, start.getAmt(), end.getAmt());
        }
    }

    static class LastValueBuffer
    implements GenericUDAFEvaluator.AggregationBuffer {
        Object val;
        boolean firstRow;
        boolean skipNulls;

        LastValueBuffer() {
            this.init();
        }

        void init() {
            this.val = null;
            this.firstRow = true;
            this.skipNulls = false;
        }
    }
}

