/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;

public class StringExpr {
    public static int compare(byte[] arg1, int start1, int len1, byte[] arg2, int start2, int len2) {
        for (int i = 0; i < len1 && i < len2; ++i) {
            int b1 = arg1[i + start1] & 0xFF;
            int b2 = arg2[i + start2] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    public static int characterCount(byte[] bytes) {
        int end = bytes.length;
        int charCount = 0;
        for (int j = 0; j < end; ++j) {
            if ((bytes[j] & 0xC0) == 128) continue;
            ++charCount;
        }
        return charCount;
    }

    public static int characterCount(byte[] bytes, int start, int length) {
        int end = start + length;
        int charCount = 0;
        for (int j = start; j < end; ++j) {
            if ((bytes[j] & 0xC0) == 128) continue;
            ++charCount;
        }
        return charCount;
    }

    public static void assign(BytesColumnVector outV, int i, byte[] bytes, int start, int length) {
        outV.setVal(i, bytes, start, length);
    }

    public static int rightTrim(byte[] bytes, int start, int length) {
        int j;
        for (j = start + length - 1; j >= start && bytes[j] == 32; --j) {
        }
        return j - start + 1;
    }

    public static void rightTrim(BytesColumnVector outV, int i, byte[] bytes, int start, int length) {
        int j;
        for (j = start + length - 1; j >= start && bytes[j] == 32; --j) {
        }
        outV.setVal(i, bytes, start, j - start + 1);
    }

    public static int truncate(byte[] bytes, int start, int length, int maxLength) {
        int j;
        int end = start + length;
        int charCount = 0;
        for (j = start; j < end; ++j) {
            if ((bytes[j] & 0xC0) == 128) continue;
            if (charCount == maxLength) break;
            ++charCount;
        }
        return j - start;
    }

    public static void truncate(BytesColumnVector outV, int i, byte[] bytes, int start, int length, int maxLength) {
        int j;
        int end = start + length;
        int charCount = 0;
        for (j = start; j < end; ++j) {
            if ((bytes[j] & 0xC0) == 128) continue;
            if (charCount == maxLength) break;
            ++charCount;
        }
        outV.setVal(i, bytes, start, j - start);
    }

    public static byte[] truncateScalar(byte[] bytes, int maxLength) {
        int j;
        int end = bytes.length;
        int charCount = 0;
        for (j = 0; j < end; ++j) {
            if ((bytes[j] & 0xC0) == 128) continue;
            if (charCount == maxLength) break;
            ++charCount;
        }
        if (j == end) {
            return bytes;
        }
        return Arrays.copyOf(bytes, j);
    }

    public static int rightTrimAndTruncate(byte[] bytes, int start, int length, int maxLength) {
        int j;
        int end = start + length;
        int charCount = 0;
        int padRunStart = -1;
        for (j = start; j < end; ++j) {
            if ((bytes[j] & 0xC0) != 128) {
                if (charCount == maxLength) break;
                if (bytes[j] == 32) {
                    if (padRunStart == -1) {
                        padRunStart = j;
                    }
                } else {
                    padRunStart = -1;
                }
                ++charCount;
                continue;
            }
            padRunStart = -1;
        }
        if (padRunStart != -1) {
            return padRunStart - start;
        }
        return j - start;
    }

    public static void rightTrimAndTruncate(BytesColumnVector outV, int i, byte[] bytes, int start, int length, int maxLength) {
        int j;
        int end = start + length;
        int charCount = 0;
        int padRunStart = -1;
        for (j = start; j < end; ++j) {
            if ((bytes[j] & 0xC0) != 128) {
                if (charCount == maxLength) break;
                if (bytes[j] == 32) {
                    if (padRunStart == -1) {
                        padRunStart = j;
                    }
                } else {
                    padRunStart = -1;
                }
                ++charCount;
                continue;
            }
            padRunStart = -1;
        }
        if (padRunStart != -1) {
            outV.setVal(i, bytes, start, padRunStart - start);
        } else {
            outV.setVal(i, bytes, start, j - start);
        }
    }

    public static byte[] rightTrimAndTruncateScalar(byte[] bytes, int maxLength) {
        int j;
        int end = bytes.length;
        int charCount = 0;
        int padRunStart = -1;
        for (j = 0; j < end; ++j) {
            if ((bytes[j] & 0xC0) != 128) {
                if (charCount == maxLength) break;
                if (bytes[j] == 32) {
                    if (padRunStart == -1) {
                        padRunStart = j;
                    }
                } else {
                    padRunStart = -1;
                }
                ++charCount;
                continue;
            }
            padRunStart = -1;
        }
        if (padRunStart != -1) {
            return Arrays.copyOf(bytes, padRunStart);
        }
        if (j == end) {
            return bytes;
        }
        return Arrays.copyOf(bytes, j);
    }
}

