/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Locator {
    private final Type type;
    private final String value;
    private Optional<Boolean> ignoreCase = Optional.empty();
    private Optional<String> matchType = Optional.empty();
    private Optional<Long> maxDepth = Optional.empty();

    private Locator(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public Locator(Type type, String value, Optional<Boolean> ignoreCase, Optional<String> matchType, Optional<Long> maxDepth) {
        this.type = type;
        this.value = value;
        this.ignoreCase = ignoreCase;
        this.matchType = matchType;
        this.maxDepth = maxDepth;
    }

    public static Locator css(String value) {
        return new Locator(Type.CSS, value);
    }

    public static Locator innerText(String value, Optional<Boolean> ignoreCase, Optional<String> matchType, Optional<Long> maxDepth) {
        return new Locator(Type.INNER, value, ignoreCase, matchType, maxDepth);
    }

    public static Locator innerText(String value) {
        return new Locator(Type.INNER, value);
    }

    public static Locator xpath(String value) {
        return new Locator(Type.XPATH, value);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", this.type.toString());
        map.put("value", this.value);
        this.ignoreCase.ifPresent(val -> map.put("ignoreCase", val));
        this.matchType.ifPresent(val -> map.put("matchType", val));
        this.maxDepth.ifPresent(val -> map.put("maxDepth", val));
        return map;
    }

    private static enum Type {
        CSS("css"),
        INNER("innerText"),
        XPATH("xpath");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

