/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.domsnapshot;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.v142.domsnapshot.model.ComputedStyle;
import org.openqa.selenium.devtools.v142.domsnapshot.model.DOMNode;
import org.openqa.selenium.devtools.v142.domsnapshot.model.DocumentSnapshot;
import org.openqa.selenium.devtools.v142.domsnapshot.model.LayoutTreeNode;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DOMSnapshot {
    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOMSnapshot.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("DOMSnapshot.enable", Map.copyOf(params));
    }

    @Deprecated
    public static Command<GetSnapshotResponse> getSnapshot(List<String> computedStyleWhitelist, Optional<Boolean> includeEventListeners, Optional<Boolean> includePaintOrder, Optional<Boolean> includeUserAgentShadowTree) {
        Objects.requireNonNull(computedStyleWhitelist, "computedStyleWhitelist is required");
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("computedStyleWhitelist", computedStyleWhitelist);
        includeEventListeners.ifPresent(p -> params.put("includeEventListeners", (List<String>)p));
        includePaintOrder.ifPresent(p -> params.put("includePaintOrder", (List<String>)p));
        includeUserAgentShadowTree.ifPresent(p -> params.put("includeUserAgentShadowTree", (List<String>)p));
        return new Command("DOMSnapshot.getSnapshot", Map.copyOf(params), input -> (GetSnapshotResponse)input.read(GetSnapshotResponse.class));
    }

    public static Command<CaptureSnapshotResponse> captureSnapshot(List<String> computedStyles, Optional<Boolean> includePaintOrder, Optional<Boolean> includeDOMRects, Optional<Boolean> includeBlendedBackgroundColors, Optional<Boolean> includeTextColorOpacities) {
        Objects.requireNonNull(computedStyles, "computedStyles is required");
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("computedStyles", computedStyles);
        includePaintOrder.ifPresent(p -> params.put("includePaintOrder", (List<String>)p));
        includeDOMRects.ifPresent(p -> params.put("includeDOMRects", (List<String>)p));
        includeBlendedBackgroundColors.ifPresent(p -> params.put("includeBlendedBackgroundColors", (List<String>)p));
        includeTextColorOpacities.ifPresent(p -> params.put("includeTextColorOpacities", (List<String>)p));
        return new Command("DOMSnapshot.captureSnapshot", Map.copyOf(params), input -> (CaptureSnapshotResponse)input.read(CaptureSnapshotResponse.class));
    }

    public static class CaptureSnapshotResponse {
        private final List<DocumentSnapshot> documents;
        private final List<String> strings;

        public CaptureSnapshotResponse(List<DocumentSnapshot> documents, List<String> strings) {
            this.documents = Objects.requireNonNull(documents, "documents is required");
            this.strings = Objects.requireNonNull(strings, "strings is required");
        }

        public List<DocumentSnapshot> getDocuments() {
            return this.documents;
        }

        public List<String> getStrings() {
            return this.strings;
        }

        private static CaptureSnapshotResponse fromJson(JsonInput input) {
            List documents = null;
            List strings = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "documents": {
                        documents = input.readArray(DocumentSnapshot.class);
                        continue block8;
                    }
                    case "strings": {
                        strings = input.readArray(String.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new CaptureSnapshotResponse(documents, strings);
        }
    }

    public static class GetSnapshotResponse {
        private final List<DOMNode> domNodes;
        private final List<LayoutTreeNode> layoutTreeNodes;
        private final List<ComputedStyle> computedStyles;

        public GetSnapshotResponse(List<DOMNode> domNodes, List<LayoutTreeNode> layoutTreeNodes, List<ComputedStyle> computedStyles) {
            this.domNodes = Objects.requireNonNull(domNodes, "domNodes is required");
            this.layoutTreeNodes = Objects.requireNonNull(layoutTreeNodes, "layoutTreeNodes is required");
            this.computedStyles = Objects.requireNonNull(computedStyles, "computedStyles is required");
        }

        public List<DOMNode> getDomNodes() {
            return this.domNodes;
        }

        public List<LayoutTreeNode> getLayoutTreeNodes() {
            return this.layoutTreeNodes;
        }

        public List<ComputedStyle> getComputedStyles() {
            return this.computedStyles;
        }

        private static GetSnapshotResponse fromJson(JsonInput input) {
            List domNodes = null;
            List layoutTreeNodes = null;
            List computedStyles = null;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "domNodes": {
                        domNodes = input.readArray(DOMNode.class);
                        continue block10;
                    }
                    case "layoutTreeNodes": {
                        layoutTreeNodes = input.readArray(LayoutTreeNode.class);
                        continue block10;
                    }
                    case "computedStyles": {
                        computedStyles = input.readArray(ComputedStyle.class);
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetSnapshotResponse(domNodes, layoutTreeNodes, computedStyles);
        }
    }
}

