/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeOptions {
    public static final String CAPABILITY = "chromeOptions";
    private String binary;
    private List<String> args = Lists.newArrayList();
    private List<File> extensionFiles = Lists.newArrayList();
    private List<String> extensions = Lists.newArrayList();
    private Map<String, Object> experimentalOptions = Maps.newHashMap();

    public void setBinary(File path) {
        this.binary = ((File)Preconditions.checkNotNull((Object)path)).getPath();
    }

    public void setBinary(String path) {
        this.binary = (String)Preconditions.checkNotNull((Object)path);
    }

    public void addArguments(String ... arguments) {
        this.addArguments((List<String>)ImmutableList.copyOf((Object[])arguments));
    }

    public void addArguments(List<String> arguments) {
        this.args.addAll(arguments);
    }

    public void addExtensions(File ... paths) {
        this.addExtensions((List<File>)ImmutableList.copyOf((Object[])paths));
    }

    public void addExtensions(List<File> paths) {
        for (File path : paths) {
            Preconditions.checkNotNull((Object)path);
            Preconditions.checkArgument((boolean)path.exists(), (String)"%s does not exist", (Object[])new Object[]{path.getAbsolutePath()});
            Preconditions.checkArgument((!path.isDirectory() ? 1 : 0) != 0, (String)"%s is a directory", (Object[])new Object[]{path.getAbsolutePath()});
        }
        this.extensionFiles.addAll(paths);
    }

    public void addEncodedExtensions(String ... encoded) {
        this.addEncodedExtensions((List<String>)ImmutableList.copyOf((Object[])encoded));
    }

    public void addEncodedExtensions(List<String> encoded) {
        for (String extension : encoded) {
            Preconditions.checkNotNull((Object)extension);
        }
        this.extensions.addAll(encoded);
    }

    public void setExperimentalOption(String name, Object value) {
        this.experimentalOptions.put((String)Preconditions.checkNotNull((Object)name), value);
    }

    public Object getExperimentalOption(String name) {
        return this.experimentalOptions.get(Preconditions.checkNotNull((Object)name));
    }

    public JsonElement toJson() throws IOException {
        HashMap options = Maps.newHashMap();
        for (String key : this.experimentalOptions.keySet()) {
            options.put(key, this.experimentalOptions.get(key));
        }
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", ImmutableList.copyOf(this.args));
        ArrayList encoded_extensions = Lists.newArrayListWithExpectedSize((int)(this.extensionFiles.size() + this.extensions.size()));
        for (File path : this.extensionFiles) {
            String encoded = Base64.getEncoder().encodeToString(Files.toByteArray((File)path));
            encoded_extensions.add(encoded);
        }
        encoded_extensions.addAll(this.extensions);
        options.put("extensions", encoded_extensions);
        return new Gson().toJsonTree((Object)options);
    }

    DesiredCapabilities toCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        capabilities.setCapability(CAPABILITY, (Object)this);
        return capabilities;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ChromeOptions)) {
            return false;
        }
        ChromeOptions that = (ChromeOptions)other;
        return Objects.equal((Object)this.binary, (Object)that.binary) && Objects.equal(this.args, that.args) && Objects.equal(this.extensionFiles, that.extensionFiles) && Objects.equal(this.experimentalOptions, that.experimentalOptions) && Objects.equal(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.binary, this.args, this.extensionFiles, this.experimentalOptions, this.extensions});
    }
}

