/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.io;

import java.io.IOException;
import org.seleniumhq.jetty7.io.Connection;
import org.seleniumhq.jetty7.io.EndPoint;
import org.seleniumhq.jetty7.util.log.Log;
import org.seleniumhq.jetty7.util.log.Logger;

public abstract class AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(AbstractConnection.class);
    private final long _timeStamp;
    protected final EndPoint _endp;

    public AbstractConnection(EndPoint endp) {
        this._endp = endp;
        this._timeStamp = System.currentTimeMillis();
    }

    public AbstractConnection(EndPoint endp, long timestamp) {
        this._endp = endp;
        this._timeStamp = timestamp;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    public void onIdleExpired(long idleForMs) {
        try {
            LOG.debug("onIdleExpired {}ms {} {}", idleForMs, this, this._endp);
            if (this._endp.isInputShutdown() || this._endp.isOutputShutdown()) {
                this._endp.close();
            } else {
                this._endp.shutdownOutput();
            }
        }
        catch (IOException e) {
            LOG.ignore(e);
            try {
                this._endp.close();
            }
            catch (IOException e2) {
                LOG.ignore(e2);
            }
        }
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

