/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.SecurityContext;
import org.resteasy.Dispatcher;
import org.resteasy.Headers;
import org.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.resteasy.plugins.server.servlet.HttpServletResponseWrapper;
import org.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.resteasy.specimpl.HttpHeadersImpl;
import org.resteasy.specimpl.MultivaluedMapImpl;
import org.resteasy.specimpl.PathSegmentImpl;
import org.resteasy.specimpl.UriBuilderImpl;
import org.resteasy.specimpl.UriInfoImpl;
import org.resteasy.spi.Registry;
import org.resteasy.spi.ResteasyProviderFactory;
import org.resteasy.util.MediaTypeHelper;
import org.resteasy.util.PathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletDispatcher
extends HttpServlet {
    private Dispatcher dispatcher;

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)((Object)servletConfig.getServletContext().getAttribute(ResteasyProviderFactory.class.getName()));
        if (providerFactory == null) {
            providerFactory = new ResteasyProviderFactory();
            servletConfig.getServletContext().setAttribute(ResteasyProviderFactory.class.getName(), (Object)providerFactory);
        }
        this.dispatcher = (Dispatcher)servletConfig.getServletContext().getAttribute(Dispatcher.class.getName());
        if (this.dispatcher == null) {
            this.dispatcher = new Dispatcher(providerFactory);
            servletConfig.getServletContext().setAttribute(Dispatcher.class.getName(), (Object)this.dispatcher);
            servletConfig.getServletContext().setAttribute(Registry.class.getName(), (Object)this.dispatcher.getRegistry());
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.service(httpServletRequest.getMethod(), httpServletRequest, httpServletResponse);
    }

    public void invoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.service(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(String httpMethod, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpServletInputMessage in;
        HttpHeaders headers = HttpServletDispatcher.extractHttpHeaders(request);
        String path = PathHelper.getEncodedPathInfo(request.getRequestURI(), request.getContextPath());
        URI absolutePath = null;
        try {
            URL absolute = new URL(request.getRequestURL().toString());
            UriBuilderImpl builder = new UriBuilderImpl();
            builder.scheme(absolute.getProtocol());
            builder.host(absolute.getHost());
            builder.port(absolute.getPort());
            builder.path(absolute.getPath());
            builder.replaceQueryParams(absolute.getQuery());
            absolutePath = builder.build();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        List<PathSegment> pathSegments = PathSegmentImpl.parseSegments(path);
        UriInfoImpl uriInfo = new UriInfoImpl(absolutePath, path, request.getQueryString(), pathSegments);
        try {
            in = new HttpServletInputMessage(headers, (InputStream)request.getInputStream(), uriInfo, httpMethod.toUpperCase());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HttpServletResponseWrapper theResponse = new HttpServletResponseWrapper(response, this.dispatcher.getProviderFactory());
        try {
            ResteasyProviderFactory.pushContext(HttpServletRequest.class, request);
            ResteasyProviderFactory.pushContext(HttpServletResponse.class, response);
            ResteasyProviderFactory.pushContext(SecurityContext.class, new ServletSecurityContext(request));
            this.dispatcher.invoke(in, theResponse);
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
    }

    public static HttpHeaders extractHttpHeaders(HttpServletRequest request) {
        HttpHeadersImpl headers = new HttpHeadersImpl();
        MultivaluedMapImpl<String, String> requestHeaders = HttpServletDispatcher.extractRequestHeaders(request);
        headers.setRequestHeaders(requestHeaders);
        List<MediaType> acceptableMediaTypes = HttpServletDispatcher.extractAccepts(requestHeaders);
        List<String> acceptableLanguages = HttpServletDispatcher.extractLanguages(requestHeaders);
        headers.setAcceptableMediaTypes(acceptableMediaTypes);
        headers.setAcceptableLanguages(acceptableLanguages);
        headers.setLanguage(requestHeaders.getFirst("Content-Language"));
        String contentType = request.getContentType();
        if (contentType != null) {
            headers.setMediaType(MediaType.valueOf((String)contentType));
        }
        Map<String, Cookie> cookies = HttpServletDispatcher.extractCookies(request);
        headers.setCookies(cookies);
        return headers;
    }

    private static Map<String, Cookie> extractCookies(HttpServletRequest request) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        if (request.getCookies() != null) {
            for (javax.servlet.http.Cookie cookie : request.getCookies()) {
                cookies.put(cookie.getName(), new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion()));
            }
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMapImpl<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get("Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader(accept));
        }
        return acceptableMediaTypes;
    }

    public static List<String> extractLanguages(MultivaluedMapImpl<String, String> requestHeaders) {
        ArrayList<String> acceptable = new ArrayList<String>();
        List accepts = (List)requestHeaders.get("Accept-Language");
        if (accepts == null) {
            return acceptable;
        }
        for (String accept : accepts) {
            String[] splits;
            for (String split : splits = accept.split(",")) {
                acceptable.add(split.trim());
            }
        }
        return acceptable;
    }

    public static MultivaluedMapImpl<String, String> extractRequestHeaders(HttpServletRequest request) {
        Headers<String> requestHeaders = new Headers<String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                requestHeaders.add(headerName, headerValue);
            }
        }
        return requestHeaders;
    }
}

