/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import org.resteasy.Failure;
import org.resteasy.ResourceInvoker;
import org.resteasy.ResourceLocator;
import org.resteasy.ResourceMethod;
import org.resteasy.spi.HttpRequest;
import org.resteasy.spi.HttpResponse;
import org.resteasy.util.PathHelper;
import org.resteasy.util.SegmentInfo;
import org.resteasy.util.WeightedMediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathSegmentNode {
    private List<ResourceMethod> invokers = new ArrayList<ResourceMethod>();
    private ResourceLocator locator;
    private Map<String, PathSegmentNode> children = new HashMap<String, PathSegmentNode>();
    private Map<String, PathSegmentNode> uriParamChildren = new HashMap<String, PathSegmentNode>();
    private List<PathSegmentNode> sortedUriParamChildren = new ArrayList<PathSegmentNode>();
    private SegmentInfo uriParamPattern;
    private boolean wildcard;

    public void addChild(String[] path, int pathIndex, ResourceMethod invoker, boolean wildcard) {
        String segment = path[pathIndex];
        Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(segment);
        if (matcher.find()) {
            SegmentInfo info = new SegmentInfo(segment);
            PathSegmentNode child = this.uriParamChildren.get(info.getExpression());
            if (child == null) {
                child = new PathSegmentNode();
                this.uriParamChildren.put(info.getExpression(), child);
                child.uriParamPattern = info;
                this.sortedUriParamChildren.add(child);
                Collections.sort(this.sortedUriParamChildren, new SortUriParamChild());
            }
            if (path.length == pathIndex + 1) {
                child.invokers.add(invoker);
                child.wildcard = wildcard;
            } else {
                child.addChild(path, pathIndex + 1, invoker, wildcard);
            }
        } else {
            PathSegmentNode child = this.children.get(segment);
            if (child == null) {
                child = new PathSegmentNode();
                this.children.put(segment, child);
            }
            if (path.length == pathIndex + 1) {
                child.invokers.add(invoker);
                child.wildcard = wildcard;
            } else {
                child.addChild(path, pathIndex + 1, invoker, wildcard);
            }
        }
    }

    public void addChild(String[] path, int pathIndex, ResourceLocator locator) {
        String segment = path[pathIndex];
        Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(segment);
        if (matcher.find()) {
            SegmentInfo info = new SegmentInfo(segment);
            PathSegmentNode child = this.uriParamChildren.get(info.getExpression());
            if (child == null) {
                child = new PathSegmentNode();
                this.uriParamChildren.put(info.getExpression(), child);
                child.uriParamPattern = info;
                this.sortedUriParamChildren.add(child);
                Collections.sort(this.sortedUriParamChildren, new SortUriParamChild());
            }
            if (path.length == pathIndex + 1) {
                child.locator = locator;
                locator.setUriIndex(pathIndex + 1);
            } else {
                child.addChild(path, pathIndex + 1, locator);
            }
        } else {
            PathSegmentNode child = this.children.get(path[pathIndex]);
            if (child == null) {
                child = new PathSegmentNode();
                this.children.put(path[pathIndex], child);
            }
            if (path.length == pathIndex + 1) {
                child.locator = locator;
                locator.setUriIndex(pathIndex + 1);
            } else {
                child.addChild(path, pathIndex + 1, locator);
            }
        }
    }

    public ResourceInvoker removeChild(String[] path, int pathIndex, Method method) {
        String segment = path[pathIndex];
        Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(path[pathIndex]);
        if (matcher.find()) {
            String regex = PathHelper.createRegularExpressionFromPathExpression(segment);
            PathSegmentNode child = this.uriParamChildren.get(regex);
            if (child == null) {
                return null;
            }
            if (path.length == pathIndex + 1) {
                ResourceInvoker rm = this.tryRemoveInvoker(child.invokers, method);
                if (rm != null) {
                    return rm;
                }
                return null;
            }
            ResourceInvoker rm = child.removeChild(path, pathIndex + 1, method);
            if (rm != null) {
                return rm;
            }
            return null;
        }
        PathSegmentNode child = this.children.get(segment);
        if (path.length == pathIndex + 1) {
            return this.tryRemoveInvoker(child.invokers, method);
        }
        return child.removeChild(path, pathIndex + 1, method);
    }

    public ResourceInvoker removeLocator(String[] path, int pathIndex) {
        String segment = path[pathIndex];
        Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(segment);
        if (matcher.matches()) {
            String regex = PathHelper.createRegularExpressionFromPathExpression(segment);
            PathSegmentNode child = this.uriParamChildren.get(regex);
            if (path.length == pathIndex + 1) {
                if (child == null) {
                    return null;
                }
                if (child.locator != null) {
                    ResourceLocator invoker = child.locator;
                    child.locator = null;
                    return invoker;
                }
                return null;
            }
            if (child == null) {
                return null;
            }
            ResourceInvoker rm = child.removeLocator(path, pathIndex + 1);
            if (rm != null) {
                return rm;
            }
            return null;
        }
        PathSegmentNode child = this.children.get(path[pathIndex]);
        if (path.length == pathIndex + 1) {
            ResourceLocator invoker = child.locator;
            child.locator = null;
            return invoker;
        }
        return child.removeLocator(path, pathIndex + 1);
    }

    private ResourceInvoker tryRemoveInvoker(List<ResourceMethod> invokers, Method method) {
        ArrayList<ResourceMethod> copy = new ArrayList<ResourceMethod>();
        copy.addAll(invokers);
        Iterator i$ = copy.iterator();
        if (i$.hasNext()) {
            ResourceMethod rm = (ResourceMethod)i$.next();
            if (method.equals(rm.getMethod())) {
                invokers.remove(rm);
            }
            return rm;
        }
        return null;
    }

    public PathSegmentNode getChild(String segment) {
        return this.children.get(segment);
    }

    public ResourceInvoker findResourceInvoker(HttpRequest request, HttpResponse response, int pathIndex) {
        if (pathIndex >= request.getPreProcessedSegments().size() || this.wildcard) {
            return this.match(request.getHttpMethod(), request.getHttpHeaders().getMediaType(), request.getHttpHeaders().getAcceptableMediaTypes());
        }
        return this.findChild(request, response, pathIndex);
    }

    private ResourceInvoker findChild(HttpRequest request, HttpResponse response, int pathIndex) {
        Failure failure;
        String segment;
        block11: {
            List<PathSegment> path = request.getPreProcessedSegments();
            segment = path.get(pathIndex).getPath();
            PathSegmentNode next = this.children.get(segment);
            failure = null;
            if (next != null) {
                try {
                    if (next.wildcard) {
                        return next.match(request.getHttpMethod(), request.getHttpHeaders().getMediaType(), request.getHttpHeaders().getAcceptableMediaTypes());
                    }
                    ResourceInvoker method = next.findResourceInvoker(request, response, pathIndex + 1);
                    if (method != null) {
                        return method;
                    }
                }
                catch (Failure e) {
                    failure = e;
                    if (!path.get(pathIndex).getPath().equals("")) break block11;
                    throw failure;
                }
            }
        }
        for (PathSegmentNode uriParamChild : this.sortedUriParamChildren) {
            if (!uriParamChild.uriParamPattern.getPattern().matcher(segment).matches()) continue;
            try {
                if (uriParamChild.wildcard) {
                    return uriParamChild.match(request.getHttpMethod(), request.getHttpHeaders().getMediaType(), request.getHttpHeaders().getAcceptableMediaTypes());
                }
                ResourceInvoker result = uriParamChild.findResourceInvoker(request, response, pathIndex + 1);
                if (result == null) continue;
                return result;
            }
            catch (Failure e) {
                failure = e;
            }
        }
        if (this.locator != null) {
            return this.locator;
        }
        if (failure != null) {
            throw failure;
        }
        return null;
    }

    private ResourceInvoker match(String httpMethod, MediaType contentType, List<MediaType> oldaccepts) {
        ArrayList<WeightedMediaType> accepts = new ArrayList<WeightedMediaType>();
        for (MediaType accept : oldaccepts) {
            accepts.add(WeightedMediaType.parse(accept));
        }
        ArrayList<ResourceMethod> list = new ArrayList<ResourceMethod>();
        IdentityHashMap<WeightedMediaType, ResourceMethod> consumesMap = new IdentityHashMap<WeightedMediaType, ResourceMethod>();
        boolean methodMatch = false;
        boolean consumeMatch = false;
        for (ResourceMethod invoker : this.invokers) {
            if (!invoker.getHttpMethods().contains(httpMethod)) continue;
            methodMatch = true;
            if (!invoker.doesConsume(contentType)) continue;
            consumeMatch = true;
            if (!invoker.doesProduce(accepts)) continue;
            list.add(invoker);
            if (invoker.getConsumes() == null) {
                WeightedMediaType defaultConsumes = WeightedMediaType.valueOf("*/*;q=0.0");
                consumesMap.put(defaultConsumes, invoker);
                continue;
            }
            for (WeightedMediaType consume : invoker.getPreferredConsumes()) {
                consumesMap.put(consume, invoker);
            }
        }
        if (list.size() == 0) {
            if (this.locator != null) {
                return this.locator;
            }
            if (!methodMatch) {
                throw new Failure("No matching http method", 405);
            }
            if (!consumeMatch) {
                throw new Failure("Cannot consume content type", 415);
            }
            throw new Failure("No match for accept header", 406);
        }
        if (list.size() == 1) {
            return (ResourceInvoker)list.get(0);
        }
        list = new ArrayList();
        ArrayList consumes = new ArrayList();
        consumes.addAll(consumesMap.keySet());
        Collections.sort(consumes);
        boolean first = true;
        WeightedMediaType current = null;
        for (WeightedMediaType type : consumes) {
            if (first) {
                list.add((ResourceMethod)consumesMap.get(type));
                current = type;
                first = false;
                continue;
            }
            if (current.compareTo(type) != 0) break;
            list.add((ResourceMethod)consumesMap.get(type));
        }
        if (list.size() == 1) {
            return (ResourceInvoker)list.get(0);
        }
        IdentityHashMap<WeightedMediaType, ResourceMethod> producesMap = new IdentityHashMap<WeightedMediaType, ResourceMethod>();
        for (ResourceMethod invoker : list) {
            if (invoker.getProduces() == null) {
                WeightedMediaType defaultProduces = WeightedMediaType.valueOf("*/*;q=0.0");
                producesMap.put(defaultProduces, invoker);
                continue;
            }
            for (WeightedMediaType produce : invoker.getPreferredProduces()) {
                producesMap.put(produce, invoker);
            }
        }
        if (accepts == null || accepts.size() == 0) {
            accepts = new ArrayList(1);
            accepts.add(WeightedMediaType.valueOf("*/*"));
        }
        ArrayList produces = new ArrayList();
        produces.addAll(producesMap.keySet());
        Collections.sort(produces);
        Collections.sort(accepts);
        for (WeightedMediaType accept : accepts) {
            for (WeightedMediaType produce : produces) {
                if (!accept.isCompatible(produce)) continue;
                return (ResourceInvoker)producesMap.get(produce);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortUriParamChild
    implements Comparator<PathSegmentNode> {
        private SortUriParamChild() {
        }

        @Override
        public int compare(PathSegmentNode pathSegmentNode, PathSegmentNode pathSegmentNode1) {
            return pathSegmentNode.uriParamPattern.compareTo(pathSegmentNode1.uriParamPattern);
        }
    }
}

