/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMNavigator
implements Navigator {
    @Override
    public Object getRoot(Object node) throws XPathException {
        return ((Node)node).getOwnerDocument().getDocumentElement();
    }

    @Override
    public Object getParent(Object node) throws XPathException {
        Node parent = ((Node)node).getParentNode();
        if (parent instanceof Document) {
            return null;
        }
        return parent;
    }

    @Override
    public Object nextSibling(Object node) throws XPathException {
        return ((Node)node).getNextSibling();
    }

    @Override
    public Object previousSibling(Object node) throws XPathException {
        return ((Node)node).getPreviousSibling();
    }

    @Override
    public Object getChild(Object node, int index) throws XPathException {
        return ((Node)node).getChildNodes().item(index);
    }

    @Override
    public int childCount(Object node) throws XPathException {
        return ((Node)node).getChildNodes().getLength();
    }

    @Override
    public Object getAttribute(Object node, int index) throws XPathException {
        return ((Node)node).getAttributes().item(index);
    }

    @Override
    public int attributeCount(Object node) throws XPathException {
        return ((Node)node).getAttributes().getLength();
    }

    @Override
    public String getName(Object node) throws XPathException {
        Node n = (Node)node;
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                return n.getNodeName();
            }
            case 3: {
                return null;
            }
        }
        throw new XPathException("Unsupported object type");
    }

    @Override
    public String getStringValue(Object node) throws XPathException {
        Node n = (Node)node;
        switch (n.getNodeType()) {
            case 2: {
                return n.getNodeValue();
            }
            case 1: 
            case 3: {
                StringBuffer sb = new StringBuffer();
                this.appendStringValue(n, sb);
                return sb.toString();
            }
        }
        throw new XPathException("Unsupported object type");
    }

    private void appendStringValue(Node node, StringBuffer sb) throws XPathException {
        switch (node.getNodeType()) {
            case 1: {
                NodeList children = node.getChildNodes();
                int size = children.getLength();
                for (int i = 0; i < size; ++i) {
                    this.appendStringValue(children.item(i), sb);
                }
                break;
            }
            case 3: {
                sb.append(node.getNodeValue());
                break;
            }
            default: {
                throw new XPathException("Unsupported object type");
            }
        }
    }

    @Override
    public int getType(Object node) throws XPathException {
        Node n = (Node)node;
        switch (n.getNodeType()) {
            case 2: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        throw new XPathException("Unsupported object type");
    }
}

