/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.regions;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.planx.msd.graph.Compactor;
import org.planx.xmlstore.UnknownReferenceException;
import org.planx.xmlstore.nodes.DVMNode;
import org.planx.xmlstore.nodes.NodeDiscriminator;
import org.planx.xmlstore.nodes.SystemNode;
import org.planx.xmlstore.regions.CanonicPolicy;
import org.planx.xmlstore.regions.FirstPolicy;
import org.planx.xmlstore.regions.Group;
import org.planx.xmlstore.regions.LeastInterRegionPolicy;
import org.planx.xmlstore.regions.Region;
import org.planx.xmlstore.regions.RegionConfiguration;
import org.planx.xmlstore.regions.RegionManager;
import org.planx.xmlstore.regions.Sharer;

public class MSDSharer
extends Sharer {
    private Compactor<SystemNode> compactor;
    private CanonicPolicy nodeNav;
    private LinkedList<Region> regions;
    private LinkedList<Region> rem;
    private LinkedList<Region> live;
    private LinkedList<Region> q1;
    private LinkedList<Region> q2;

    MSDSharer(RegionManager manager) {
        super(manager);
        RegionConfiguration conf = manager.configuration();
        if (conf.POLICY_INSTANCE == null) {
            switch (manager.configuration().POLICY) {
                case 1: {
                    conf.POLICY_INSTANCE = new FirstPolicy();
                    break;
                }
                case 2: {
                    conf.POLICY_INSTANCE = new LeastInterRegionPolicy();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown policy");
                }
            }
        }
        this.nodeNav = manager.configuration().POLICY_INSTANCE;
        NodeDiscriminator nodeDisc = new NodeDiscriminator();
        this.compactor = new Compactor<SystemNode>(this.nodeNav, nodeDisc, true);
        this.regions = new LinkedList();
        this.live = new LinkedList();
        this.rem = new LinkedList();
        this.initiateIteration();
    }

    @Override
    synchronized void addRegion(Region newRegion) throws IOException, UnknownReferenceException {
        if (newRegion == null) {
            throw new NullPointerException();
        }
        this.share(newRegion);
        this.regions.addLast(newRegion);
        if (this.regions.size() == 1) {
            this.isDiscriminated = true;
            this.isIterated = true;
            this.rem.add(newRegion);
        } else {
            this.isDiscriminated = false;
            this.isIterated = false;
            this.live.addLast(newRegion);
            this.revive();
        }
        this.initiateIteration();
    }

    @Override
    synchronized void removeRegion(Region region) {
        this.regions.remove(region);
        this.rem.remove(region);
        this.live.remove(region);
        this.q1.remove(region);
        this.q2.remove(region);
    }

    private synchronized void revive() {
        Group group = new Group();
        Iterator it = this.rem.iterator();
        while (it.hasNext()) {
            Region r = (Region)it.next();
            r.setGroup(group);
            it.remove();
        }
        this.live.clear();
        for (Region r : this.regions) {
            this.live.add(r);
        }
    }

    private synchronized void initiateIteration() {
        this.q1 = new LinkedList();
        this.q2 = new LinkedList();
        for (Region r : this.live) {
            r.setDirty(false);
            this.q1.offer(r);
            this.q2.offer(r);
        }
    }

    @Override
    public synchronized void share() throws IOException, UnknownReferenceException {
        Region r1 = null;
        Region r2 = null;
        do {
            if (this.q2.peek() == null) {
                if (this.q1.peek() == null) {
                    this.isIterated = true;
                    Iterator it = this.live.iterator();
                    while (it.hasNext()) {
                        Region r = (Region)it.next();
                        if (r.isDirty()) continue;
                        it.remove();
                        this.rem.add(r);
                    }
                    if (this.live.size() <= 1) {
                        this.isDiscriminated = true;
                        this.revive();
                        this.initiateIteration();
                        if (this.live.size() == 1) {
                            this.share(this.live.getFirst());
                        }
                    }
                    this.initiateIteration();
                    return;
                }
                this.q1.remove();
                for (Region r : this.q1) {
                    this.q2.offer(r);
                }
            }
            r1 = this.q1.peek();
            r2 = this.q2.poll();
        } while (r1 == null || r2 == null || r1.getGroup() == r2.getGroup());
        ++this.invocations;
        int nodesBefore = r1.currentNodes + r2.currentNodes;
        Compactor.Statistics stats = this.share(r1, r2);
        int nodesAfter = r1.currentNodes + r2.currentNodes;
        if (nodesBefore != nodesAfter) {
            r1.setDirty(true);
            r2.setDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Compactor.Statistics share(Region r) throws IOException, UnknownReferenceException {
        boolean isConsistent;
        Compactor.Statistics stats;
        Region region = r;
        synchronized (region) {
            if (!r.isClosed()) {
                throw new IllegalArgumentException("Region is not closed");
            }
            SystemNode root = r.getRegionRoot(null);
            this.nodeNav.setBounds(r.getBound(), null);
            this.nodeNav.setRegions(r, null);
            this.compactor.share(root);
            stats = this.compactor.getStatistics();
            r.persist();
            r.prepareMend(null);
            isConsistent = r.mend(null);
            assert (r.assertInterRegion()) : "inter-region inconsistency";
            r.releaseRegionRoot();
        }
        if (!isConsistent) {
            this.share(r);
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Compactor.Statistics share(Region r1, Region r2) throws IOException, UnknownReferenceException {
        boolean isConsistent;
        Compactor.Statistics stats;
        Region region = r1;
        synchronized (region) {
            Region region2 = r2;
            synchronized (region2) {
                if (!r1.isClosed()) {
                    throw new IllegalArgumentException("First Region is not closed");
                }
                if (!r2.isClosed()) {
                    throw new IllegalArgumentException("Second Region is not closed");
                }
                SystemNode root1 = r1.getRegionRoot(null);
                SystemNode root2 = r2.getRegionRoot(r1);
                DVMNode root = new DVMNode(0, "SharerRoot", new SystemNode[]{root1, root2}, null);
                this.nodeNav.setBounds(r1.getBound(), r2.getBound());
                this.nodeNav.setRegions(r1, r2);
                this.compactor.share(root);
                stats = this.compactor.getStatistics();
                r1.persist();
                r2.persist();
                r1.prepareMend(r2);
                r2.prepareMend(r1);
                isConsistent = r1.mend(r2);
                isConsistent = r2.mend(r1) & isConsistent;
                assert (r1.assertInterRegion()) : "first region inter-region inconsistency";
                assert (r2.assertInterRegion()) : "second region inter-region inconsistency";
                r1.releaseRegionRoot();
                r2.releaseRegionRoot();
            }
        }
        if (!isConsistent) {
            this.share(r1, r2);
        }
        return stats;
    }
}

