/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.planx.xmlstore.io.Streamer;

public class PersistentMap<K, V> {
    private Map<K, V> map;
    private DataOutputStream out;
    private Streamer<K> s1;
    private Streamer<V> s2;
    private boolean isSet;

    public PersistentMap(String filename, Streamer<K> s1, Streamer<V> s2) throws IOException {
        this(filename, s1, s2, false);
    }

    public PersistentMap(String filename, Streamer<K> s1, Streamer<V> s2, boolean isSet) throws IOException {
        this.s1 = s1;
        this.s2 = s2;
        this.isSet = isSet;
        this.map = new HashMap();
        this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename, true)));
        this.read(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String filename) throws IOException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
        try {
            try {
                while (true) {
                    K key = this.s1.fromStream(in);
                    Object value = this.isSet ? null : (Object)this.s2.fromStream(in);
                    this.map.put(key, value);
                }
            }
            catch (EOFException eOFException) {
                in.close();
            }
        }
        catch (Throwable throwable) {
            in.close();
            throw throwable;
        }
    }

    public synchronized V get(K key) {
        return this.map.get(key);
    }

    public synchronized void put(K key, V value) throws IOException {
        this.map.put(key, value);
        this.s1.toStream(this.out, key);
        if (!this.isSet) {
            this.s2.toStream(this.out, value);
        }
        this.out.flush();
    }

    public synchronized void replace(V oldValue, V newValue) throws IOException {
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            if (!oldValue.equals(entry.getValue())) continue;
            entry.setValue(newValue);
            this.s1.toStream(this.out, entry.getKey());
            if (this.isSet) continue;
            this.s2.toStream(this.out, newValue);
        }
    }

    public synchronized Set<K> keySet() {
        return this.map.keySet();
    }

    public synchronized Collection<V> values() {
        return this.map.values();
    }

    public synchronized String toString() {
        return this.map.toString();
    }
}

