/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.number;

import org.planx.msd.Extractor;
import org.planx.msd.Memory;
import org.planx.msd.number.NumberDiscriminator;

public class FloatDiscriminator
extends NumberDiscriminator<Float> {
    public FloatDiscriminator(Memory memory) {
        super(memory);
    }

    @Override
    protected int bitsize() {
        return 32;
    }

    @Override
    protected <U> NumberDiscriminator.ChunkExtractor<U> chunkExtractor(Extractor<U, ? extends Float, ?> e) {
        return new NumberDiscriminator.ChunkExtractor<U>(e){

            @Override
            public int getLabel(U elm) {
                Float value = (Float)this.e.getLabel(elm);
                return Float.floatToIntBits(value.floatValue()) >> this.offset & 0xFFFF;
            }
        };
    }
}

