/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.planx.msd.Discriminator;
import org.planx.msd.DiscriminatorFactory;
import org.planx.msd.Memory;
import org.planx.msd.character.CharSequenceDiscriminator;
import org.planx.msd.character.CharacterDiscriminator;
import org.planx.msd.lang.ClassDiscriminator;
import org.planx.msd.lang.PolymorphicDiscriminator;
import org.planx.msd.list.BagDiscriminator;
import org.planx.msd.list.ListDiscriminator;
import org.planx.msd.list.SetDiscriminator;
import org.planx.msd.number.ByteDiscriminator;
import org.planx.msd.number.DoubleDiscriminator;
import org.planx.msd.number.FloatDiscriminator;
import org.planx.msd.number.IntegerDiscriminator;
import org.planx.msd.number.LongDiscriminator;
import org.planx.msd.number.ShortDiscriminator;

class DiscriminatorFactoryImpl
extends DiscriminatorFactory {
    private static final Memory memory = new Memory();
    private Map<Class, PolymorphicDiscriminator> pdiscs = new HashMap<Class, PolymorphicDiscriminator>();

    DiscriminatorFactoryImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> PolymorphicDiscriminator<E> getPolymorphicDiscriminator(Class<E> cls) {
        Map<Class, PolymorphicDiscriminator> map = this.pdiscs;
        synchronized (map) {
            PolymorphicDiscriminator pd = this.pdiscs.get(cls);
            if (pd == null) {
                pd = new PolymorphicDiscriminator();
                this.pdiscs.put(cls, pd);
            }
            return pd;
        }
    }

    @Override
    public Memory getMemory() {
        return memory;
    }

    @Override
    public Discriminator<Character> getCharacterDiscriminator() {
        return new CharacterDiscriminator(memory);
    }

    @Override
    public <T extends CharSequence> Discriminator<T> getCharSequenceDiscriminator() {
        return new CharSequenceDiscriminator(memory);
    }

    @Override
    public ClassDiscriminator<Object> getClassDiscriminator() {
        return new ClassDiscriminator<Object>(memory);
    }

    @Override
    public Discriminator<Byte> getByteDiscriminator() {
        return new ByteDiscriminator(memory);
    }

    @Override
    public Discriminator<Short> getShortDiscriminator() {
        return new ShortDiscriminator(memory);
    }

    @Override
    public Discriminator<Integer> getIntegerDiscriminator() {
        return new IntegerDiscriminator(memory);
    }

    @Override
    public Discriminator<Long> getLongDiscriminator() {
        return new LongDiscriminator(memory);
    }

    @Override
    public Discriminator<Float> getFloatDiscriminator() {
        return new FloatDiscriminator(memory);
    }

    @Override
    public Discriminator<Double> getDoubleDiscriminator() {
        return new DoubleDiscriminator(memory);
    }

    @Override
    public <T> Discriminator<List<T>> getListDiscriminator(Discriminator<T> d) {
        return new ListDiscriminator<T>(d, memory);
    }

    @Override
    public <T> Discriminator<List<T>> getBagDiscriminator(Discriminator<T> d) {
        return new BagDiscriminator<T>(d, memory);
    }

    @Override
    public <T> Discriminator<List<T>> getSetDiscriminator(Discriminator<T> d) {
        return new SetDiscriminator<T>(d, memory);
    }
}

