package org.planx.xpath.expr.operator;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.object.*;

/**
 * An XPath operator.
 **/
public abstract class Operator extends Expression {
    protected final Expression e1;
    protected final Expression e2;

    public Operator(Expression e1, Expression e2) {
        this.e1 = e1;
        this.e2 = e2;
    }

    public XObject evaluate(Context ctxt, Environment env, Navigator nav)
                                                   throws XPathException {
        XObject value1 = e1.evaluate(ctxt, env, nav);
        XObject value2 = e2.evaluate(ctxt, env, nav);
        return evaluate(value1, value2, nav);
    }

    protected abstract XObject evaluate(XObject o1, XObject o2,
                                        Navigator nav) throws XPathException;

    protected abstract String operatorName();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (e1 instanceof Operator) {
            sb.append("(");
            sb.append(e1.toString());
            sb.append(")");
        } else {
            sb.append(e1.toString());
        }
        sb.append(operatorName());
        if (e2 instanceof Operator) {
            sb.append("(");
            sb.append(e2.toString());
            sb.append(")");
        } else {
            sb.append(e2.toString());
        }
        return sb.toString();
    }
}
