/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.axis.Axis;
import org.planx.xpath.expr.axis.AxisIterator;

public class ParentAxis
extends Axis {
    @Override
    public AxisIterator iterator(Object contextNode, Navigator navigator) throws XPathException {
        return new ParentAxisIterator(contextNode, navigator);
    }

    @Override
    public int getPrincipalNodeType() {
        return 2;
    }

    @Override
    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "parent";
    }

    class ParentAxisIterator
    implements AxisIterator {
        private Object parentNode = null;
        private XPathException parentException = null;
        private boolean isDone = false;

        ParentAxisIterator(Object contextNode, Navigator navigator) throws XPathException {
            try {
                this.parentNode = navigator.getParent(contextNode);
            }
            catch (XPathException e) {
                this.parentException = e;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.isDone && this.parentNode != null;
        }

        @Override
        public Object next() throws XPathException {
            if (this.isDone) {
                throw new XPathException("No more elements in iterator");
            }
            if (this.parentException != null) {
                throw this.parentException;
            }
            this.isDone = true;
            return this.parentNode;
        }
    }
}

