/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing;

import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.planx.xmlstore.routing.Configuration;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.KademliaNeighbourhoodListener;
import org.planx.xmlstore.routing.NeighbourhoodListener;
import org.planx.xmlstore.routing.Node;

public class Space {
    private static Random random = new Random();
    private final Identifier localId;
    private final Space parent;
    private Space closeChild = null;
    private Space farChild = null;
    private final int depth;
    private final BigInteger startIndex;
    private Map bucket;
    private long lastLookup = 0L;
    private Map cache;
    private Configuration conf;
    private KademliaNeighbourhoodListener listener;
    private List listeners = new ArrayList();

    public Space(Node local, Configuration conf) {
        this(local, conf, null);
    }

    public Space(Node local, Configuration conf, KademliaNeighbourhoodListener listener) {
        this.conf = conf;
        this.parent = null;
        this.localId = local.getId();
        this.listener = listener;
        this.depth = 0;
        this.startIndex = BigInteger.ZERO;
        this.bucket = new HashMap();
        this.cache = new HashMap();
        this.insertNode(local);
    }

    private Space(Space parent, int depth, Identifier localId, BigInteger startIndex, Configuration conf, KademliaNeighbourhoodListener listener) {
        this.parent = parent;
        this.depth = depth;
        this.localId = localId;
        this.startIndex = startIndex;
        this.conf = conf;
        this.listener = listener;
        this.bucket = new HashMap();
        this.cache = new HashMap();
    }

    public synchronized void addNeighbourhoodListener(NeighbourhoodListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeNeighbourhoodListener(NeighbourhoodListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized List getClosestNodes(Identifier id) {
        ArrayList foundNodes = new ArrayList(this.conf.K);
        this.gatherNodes(id, id.value().xor(this.localId.value()), foundNodes);
        return foundNodes;
    }

    private void gatherNodes(Identifier id, BigInteger distance, List foundNodes) {
        if (this.bucket == null) {
            this.closestChild(distance).gatherNodes(id, distance, foundNodes);
            if (foundNodes.size() < this.conf.K) {
                this.farthestChild(distance).gatherNodes(id, distance, foundNodes);
            }
        } else if (this.conf.K - foundNodes.size() >= this.bucket.size()) {
            foundNodes.addAll(this.bucket.values());
        } else {
            Object[] sorted = new Object[this.bucket.size()];
            sorted = this.bucket.values().toArray(sorted);
            Arrays.sort(sorted, new Node.DistanceComparator(id));
            int max = this.conf.K - foundNodes.size();
            for (int i = 0; i < max; ++i) {
                foundNodes.add(sorted[i]);
            }
        }
    }

    public synchronized boolean removeNode(Node node) {
        BigInteger distance = this.localId.value().xor(node.getId().value());
        return this.removeNode(node, distance);
    }

    private boolean removeNode(Node node, BigInteger distance) {
        if (this.bucket == null) {
            return this.closestChild(distance).removeNode(node, distance);
        }
        boolean res = false;
        Identifier id = node.getId();
        Node fn = (Node)this.bucket.get(id);
        if (fn == null) {
            fn = (Node)this.cache.get(id);
        }
        if (fn != null && fn.incFailCount() >= this.conf.STALE) {
            if (this.bucket.remove(id) != null && this.cache.size() > 0) {
                Node mostRecent = (Node)Collections.max(this.cache.values(), Node.LASTSEEN_COMPARATOR);
                this.cache.remove(mostRecent.getId());
                this.bucket.put(mostRecent.getId(), mostRecent);
                this.checkCallListener(mostRecent);
            }
            this.cache.remove(id);
            res = true;
        } else {
            res = fn == null;
        }
        this.compactify();
        return res;
    }

    public synchronized void insertNode(Node newNode) {
        BigInteger distance = this.localId.value().xor(newNode.getId().value());
        this.insertNode(newNode, distance);
    }

    private void insertNode(Node newNode, BigInteger distance) {
        if (this.bucket == null) {
            this.closestChild(distance).insertNode(newNode, distance);
        } else {
            Node oldNode = (Node)this.bucket.get(newNode.getId());
            if (oldNode != null) {
                oldNode.seenNow();
            } else if (this.bucket.size() < this.conf.K) {
                this.bucket.put(newNode.getId(), newNode);
                this.checkCallListener(newNode);
            } else if (this.isSplittable()) {
                this.split();
                this.insertNode(newNode, distance);
            } else {
                oldNode = (Node)this.cache.get(newNode.getId());
                if (oldNode != null) {
                    oldNode.seenNow();
                } else if (this.cache.size() < this.conf.RCSIZE) {
                    this.cache.put(newNode.getId(), newNode);
                } else {
                    Node leastSeen = (Node)Collections.min(this.cache.values(), Node.LASTSEEN_COMPARATOR);
                    this.cache.remove(leastSeen.getId());
                    this.cache.put(newNode.getId(), newNode);
                }
            }
            this.compactify();
        }
    }

    public synchronized List getRefreshList() {
        ArrayList<Identifier> refreshList = new ArrayList<Identifier>();
        for (int i = 1; i < Identifier.IDSIZE; ++i) {
            BigInteger start = BigInteger.ONE.shiftLeft(i);
            BigInteger rnd = new BigInteger(i, random);
            Identifier id = new Identifier(start.add(rnd).xor(this.localId.value()));
            refreshList.add(id);
        }
        return refreshList;
    }

    public synchronized List getAll() {
        ArrayList nodes = new ArrayList();
        this.addAll(nodes);
        return nodes;
    }

    private void addAll(List nodes) {
        if (this.bucket != null) {
            nodes.addAll(this.bucket.values());
        } else {
            this.closeChild.addAll(nodes);
            this.farChild.addAll(nodes);
        }
    }

    public synchronized List getNeighbourhood() {
        if (this.bucket == null) {
            return this.closeChild.getNeighbourhood();
        }
        ArrayList nodes = new ArrayList();
        nodes.addAll(this.bucket.values());
        this.addFarNodes(nodes);
        return nodes;
    }

    private void addFarNodes(List nodes) {
        if (this.parent != null && nodes.size() < this.conf.K) {
            this.parent.farChild.addAll(nodes);
            this.parent.addFarNodes(nodes);
        }
    }

    private void split() {
        BigInteger closeIndex = this.startIndex.shiftLeft(1);
        this.closeChild = new Space(this, this.depth + 1, this.localId, closeIndex, this.conf, this.listener);
        this.farChild = new Space(this, this.depth + 1, this.localId, closeIndex.or(BigInteger.ONE), this.conf, this.listener);
        this.assignNodes(this.bucket.values(), this.farChild.bucket, this.closeChild.bucket);
        this.assignNodes(this.cache.values(), this.farChild.cache, this.closeChild.cache);
        this.bucket = null;
        this.cache = null;
    }

    private void assignNodes(Collection l, Map left, Map right) {
        for (Node node : l) {
            BigInteger distance = this.localId.value().xor(node.getId().value());
            Map map = distance.testBit(Identifier.IDSIZE - 1 - this.depth) ? left : right;
            map.put(node.getId(), node);
        }
    }

    private void compactify() {
        if (this.bucket == null && this.closeChild.bucket != null && this.farChild.bucket != null && !this.isSplittable()) {
            this.bucket = new HashMap();
            this.cache = new HashMap();
            ArrayList tmp = new ArrayList(2 * this.conf.K);
            tmp.addAll(this.closeChild.bucket.values());
            tmp.addAll(this.farChild.bucket.values());
            Collections.sort(tmp, Node.FIRSTSEEN_COMPARATOR);
            for (Node node : tmp) {
                if (this.bucket.size() < this.conf.K) {
                    this.bucket.put(node.getId(), node);
                    continue;
                }
                if (this.cache.size() >= this.conf.RCSIZE) break;
                this.cache.put(node.getId(), node);
            }
            tmp = new ArrayList(2 * this.conf.RCSIZE);
            tmp.addAll(this.closeChild.cache.values());
            tmp.addAll(this.farChild.cache.values());
            Collections.sort(tmp, Node.LASTSEEN_COMPARATOR);
            Iterator it = tmp.iterator();
            while (it.hasNext() && this.cache.size() < this.conf.RCSIZE) {
                Node node;
                node = (Node)it.next();
                this.cache.put(node.getId(), node);
            }
            this.closeChild = null;
            this.farChild = null;
        }
        if (this.bucket != null && this.parent != null) {
            this.parent.compactify();
        }
    }

    private boolean isSplittable() {
        if (this.startIndex.compareTo(BigInteger.ONE.shiftLeft(this.depth % this.conf.B)) < 0) {
            return true;
        }
        return this.isUnbalanced();
    }

    private boolean isUnbalanced() {
        if (this.bucket == null && this.startIndex.equals(BigInteger.ZERO)) {
            return this.closeChild.nodeCount() < this.conf.K;
        }
        if (this.parent != null) {
            return this.parent.isUnbalanced();
        }
        return false;
    }

    private boolean isHome() {
        return this.bucket != null && this.startIndex.equals(BigInteger.ZERO);
    }

    private Space closestChild(BigInteger distance) {
        return distance.testBit(Identifier.IDSIZE - 1 - this.depth) ? this.farChild : this.closeChild;
    }

    private Space farthestChild(BigInteger distance) {
        return distance.testBit(Identifier.IDSIZE - 1 - this.depth) ? this.closeChild : this.farChild;
    }

    public int nodeCount() {
        if (this.bucket != null) {
            return this.bucket.size();
        }
        return this.closeChild.nodeCount() + this.farChild.nodeCount();
    }

    private void checkCallListener(Node node) {
        if (!this.localId.equals(node.getId()) && (this.isHome() || this.isUnbalanced())) {
            InetSocketAddress peer = new InetSocketAddress(node.getInetAddress(), node.getContactPort());
            if (this.listener != null) {
                this.listener.nodeArrived(node);
                this.listener.peerArrived(peer);
            }
            int max = this.listeners.size();
            for (int i = 0; i < max; ++i) {
                NeighbourhoodListener l = (NeighbourhoodListener)this.listeners.get(i);
                l.peerArrived(peer);
            }
        }
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString("", sb);
        return sb.toString();
    }

    private void toString(String prefix, StringBuffer sb) {
        if (sb.length() > 10000) {
            System.out.println("Probable endless loop detected, contents so far:");
            System.out.println(sb);
            System.exit(0);
        }
        if (this.bucket != null) {
            int i;
            sb.append(prefix);
            sb.append("<space depth=\"" + this.depth + "\" startIndex=\"" + this.startIndex + "\">\n");
            sb.append(prefix);
            sb.append("  <bucket size=\"" + Integer.toString(this.bucket.size()) + "\">\n");
            Node[] ns = Node.sort(this.bucket.values(), this.localId);
            for (i = 0; i < ns.length; ++i) {
                sb.append(prefix);
                sb.append("    <node xor=\"");
                sb.append(Identifier.toBinary(ns[i].getId().value().xor(this.localId.value())));
                sb.append("\"/>\n");
            }
            sb.append(prefix);
            sb.append("  </bucket>\n");
            sb.append(prefix);
            sb.append("  <cache size=\"" + Integer.toString(this.cache.size()) + "\">\n");
            ns = Node.sort(this.cache.values(), this.localId);
            for (i = 0; i < ns.length; ++i) {
                sb.append(prefix);
                sb.append("    <node xor=\"");
                sb.append(Identifier.toBinary(ns[i].getId().value().xor(this.localId.value())));
                sb.append("\"/>\n");
            }
            sb.append(prefix);
            sb.append("  </cache>\n");
            sb.append(prefix);
            sb.append("</space>\n");
        } else {
            sb.append(prefix);
            sb.append("<space depth=\"" + this.depth + "\" startIndex=\"" + this.startIndex + "\">\n");
            this.closeChild.toString(prefix + "  ", sb);
            this.farChild.toString(prefix + "  ", sb);
            sb.append(prefix);
            sb.append("</space>\n");
        }
    }
}

