/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.planx.util.UnmodifiableArrayList;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.nodes.DVMAttribute;
import org.planx.xmlstore.nodes.DVMNode;
import org.planx.xmlstore.nodes.NodeListener;
import org.planx.xmlstore.nodes.SystemNode;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DVMHandler
extends DefaultHandler {
    private NodeListener listener;
    private Stack<Element> elementStack;
    private boolean hasCharData;
    private StringBuilder charBuf;
    private SystemNode root;

    public DVMHandler() {
        this(null);
    }

    public DVMHandler(NodeListener listener) {
        if (listener == null) {
            listener = new NodeListener(){

                @Override
                public SystemNode nodeCreated(SystemNode node, int depth) {
                    return node;
                }
            };
        }
        this.listener = listener;
    }

    public SystemNode getRoot() {
        return this.root;
    }

    public void clear() {
        this.listener = null;
        this.elementStack = null;
        this.charBuf = null;
        this.root = null;
    }

    @Override
    public void startDocument() {
        this.elementStack = new Stack();
        this.charBuf = new StringBuilder();
        this.hasCharData = false;
        this.root = null;
    }

    @Override
    public void endDocument() {
        this.elementStack = null;
        this.charBuf = null;
        this.hasCharData = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.trim().length() > 0) {
            this.checkCharData();
            this.elementStack.push(new Element(qName, attributes));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.trim().length() == 0) {
            return;
        }
        this.checkCharData();
        Element elm = this.elementStack.pop();
        UnmodifiableArrayList<SystemNode> children = new UnmodifiableArrayList<SystemNode>(elm.children);
        DVMNode n = new DVMNode(0, elm.name, children, elm.attrs, null, false);
        SystemNode nref = this.listener.nodeCreated(n, this.elementStack.size());
        if (this.elementStack.empty()) {
            this.root = n;
        } else {
            this.elementStack.peek().children.add(nref);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String chars = new String(ch, start, length).trim();
        if (chars.length() > 0) {
            this.hasCharData = true;
            this.charBuf.append(chars);
        }
    }

    private void checkCharData() {
        if (this.hasCharData) {
            String s = this.charBuf.toString();
            DVMNode n = new DVMNode(1, s);
            this.charBuf = new StringBuilder();
            this.hasCharData = false;
            SystemNode nref = this.listener.nodeCreated(n, this.elementStack.size());
            this.elementStack.peek().children.add(nref);
        }
    }

    private class Element {
        String name;
        List<Attribute> attrs;
        List<SystemNode> children = new ArrayList<SystemNode>();

        Element(String name) {
            this(name, null);
        }

        Element(String name, Attributes attributes) {
            this.name = name;
            if (attributes == null) {
                this.attrs = Collections.EMPTY_LIST;
            } else {
                Attribute[] as = new Attribute[attributes.getLength()];
                for (int i = 0; i < as.length; ++i) {
                    String n = attributes.getQName(i);
                    String v = attributes.getValue(i);
                    as[i] = new DVMAttribute(n, v);
                }
                this.attrs = new UnmodifiableArrayList<Attribute>(as);
            }
        }
    }
}

