/*
 * Decompiled with CFR 0.152.
 */
package org.planx.msd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.planx.msd.Discriminator;
import org.planx.msd.Extractor;
import org.planx.msd.util.AbstractDiscriminator;

public class NullDiscriminator<T>
extends AbstractDiscriminator<T> {
    private final Discriminator<T> disc;

    public NullDiscriminator(Discriminator<T> d) {
        this.disc = d;
    }

    @Override
    public <U, S> Collection<List<S>> discriminate(List<? extends U> values, Extractor<U, ? extends T, S> e) {
        ArrayList<S> nulls = new ArrayList<S>();
        ArrayList<U> nonNulls = new ArrayList<U>(values.size());
        for (U elm : values) {
            if (e.getLabel(elm) == null) {
                nulls.add(e.getValue(elm));
                continue;
            }
            nonNulls.add(elm);
        }
        Collection<List<S>> result = this.disc.discriminate(nonNulls, e);
        if (!nulls.isEmpty()) {
            try {
                result.add(nulls);
            }
            catch (UnsupportedOperationException uoe) {
                result = new ArrayList<List<S>>(result);
                result.add(nulls);
            }
        }
        return result;
    }
}

