package org.planx.xpath.function;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.object.*;

/**
 * Core boolean function.
 **/
public class BooleanFunction implements Function {
    public XObject evaluate(XObject[] args, Context ctxt, Environment env,
                                  Navigator nav) throws FunctionException {
        if (args.length == 1) {
            if (args[0] instanceof XBoolean) {
                return args[0];
            } else {
                return new XBoolean(args[0].booleanValue());
            }
        } else {
            throw new FunctionException("Illegal number of arguments");
        }
    }
}
