/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.util.Properties;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;

public final class InterpolationUtil {
    private InterpolationUtil() {
    }

    public static String interpolate(String text, Properties properties) {
        return InterpolationUtil.interpolate(text, properties, SyntaxStyle.DEFAULT);
    }

    public static String interpolate(String text, Properties properties, SyntaxStyle style) {
        if (null == text || null == properties) {
            return text;
        }
        StringSubstitutor substitutor = style == SyntaxStyle.MSBUILD ? new StringSubstitutor((StringLookup)new PropertyLookup(properties), "$(", ")", '$') : new StringSubstitutor((StringLookup)new PropertyLookup(properties));
        return substitutor.replace(text);
    }

    private static class PropertyLookup
    implements StringLookup {
        private final Properties props;

        PropertyLookup(Properties props) {
            this.props = props;
        }

        public String lookup(String key) {
            return this.props.getProperty(key, "");
        }
    }

    public static enum SyntaxStyle {
        DEFAULT,
        MSBUILD;

    }
}

