/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.fasterxml.jackson.module.blackbird.BlackbirdModule;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import org.owasp.dependencycheck.data.nvd.ecosystem.CveEcosystemMapper;
import org.owasp.dependencycheck.data.nvd.json.DefCveItem;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.exception.CorruptedDatastreamException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NvdCveParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdCveParser.class);
    private final CveDB cveDB;
    private final Settings settings;

    public NvdCveParser(Settings settings, CveDB db) {
        this.settings = settings;
        this.cveDB = db;
    }

    public void parse(File file) throws UpdateException, CorruptedDatastreamException {
        LOGGER.debug("Parsing " + file.getName());
        Object module = NvdCveParser.getJavaVersion() <= 8 ? new AfterburnerModule() : new BlackbirdModule();
        ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).addModule((Module)module)).build();
        ObjectReader objectReader = objectMapper.readerFor(DefCveItem.class);
        try (FileInputStream fin = new FileInputStream(file);
             GZIPInputStream in = new GZIPInputStream(fin);
             InputStreamReader isr = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
             JsonParser parser = objectReader.getFactory().createParser((Reader)isr);){
            CveEcosystemMapper mapper = new CveEcosystemMapper();
            this.init(parser);
            while (parser.nextToken() == JsonToken.START_OBJECT) {
                DefCveItem cve = (DefCveItem)objectReader.readValue(parser);
                this.cveDB.updateVulnerability(cve, mapper.getEcosystem(cve));
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.error(ex.getMessage());
            throw new UpdateException("Unable to find the NVD CVE file, `" + file + "`, to parse", ex);
        }
        catch (EOFException | ZipException ex) {
            throw new CorruptedDatastreamException("Error reading parsing NVD CVE file", ex);
        }
        catch (IOException ex) {
            LOGGER.error("Error reading NVD JSON data: {}", (Object)file);
            LOGGER.debug("Error extracting the NVD JSON data from: " + file, (Throwable)ex);
            throw new UpdateException("Unable to find the NVD CVE file to parse", ex);
        }
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.specification.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    void init(JsonParser parser) throws IOException {
        JsonToken nextToken = parser.nextToken();
        if (nextToken != JsonToken.START_OBJECT) {
            throw new IOException("Expected " + JsonToken.START_OBJECT + ", got " + nextToken);
        }
        while ((nextToken = parser.nextToken()) != null) {
            if (!nextToken.isStructStart()) continue;
            if (nextToken == JsonToken.START_ARRAY) break;
            parser.skipChildren();
        }
    }
}

