/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.PythonPackageAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class PipAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonPackageAnalyzer.class);
    private static final String REQUIREMENTS = "requirements.txt";
    private static final String ANALYZER_NAME = "pip Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final Pattern PACKAGE_VERSION = Pattern.compile("^([^#].*?)(?:[=>]=([\\.\\*0-9]+?))?$", 8);
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addFilenames("requirements.txt").build();

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.pip.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        String contents;
        File dependencyFile;
        LOGGER.debug("Checking file {}", (Object)dependency.getActualFilePath());
        if (REQUIREMENTS.equals(dependency.getFileName())) {
            engine.removeDependency(dependency);
        }
        if (!(dependencyFile = dependency.getActualFile()).isFile() || dependencyFile.length() == 0L) {
            return;
        }
        File actualFile = dependency.getActualFile();
        if (actualFile.getName().equals(REQUIREMENTS) && !(contents = this.getFileContents(actualFile)).isEmpty()) {
            Matcher matcher = PACKAGE_VERSION.matcher(contents);
            while (matcher.find()) {
                String identifiedPackage = matcher.group(1);
                String identifiedVersion = matcher.group(2);
                LOGGER.debug(String.format("package, version: %s %s", identifiedPackage, identifiedVersion));
                Dependency d = new Dependency(dependency.getActualFile(), true);
                d.setName(identifiedPackage);
                d.setVersion(identifiedVersion);
                try {
                    PackageURL purl = PackageURLBuilder.aPackageURL().withType("pypi").withName(identifiedPackage).withVersion(identifiedVersion).build();
                    d.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
                }
                catch (MalformedPackageURLException ex) {
                    LOGGER.debug("Unable to build package url for pypi", (Throwable)ex);
                    d.addSoftwareIdentifier(new GenericIdentifier("pypi:" + identifiedPackage + "@" + identifiedVersion, Confidence.HIGH));
                }
                d.setPackagePath(String.format("%s:%s", identifiedPackage, identifiedVersion));
                d.setEcosystem("python");
                String filePath = String.format("%s:%s/%s", dependency.getFilePath(), identifiedPackage, identifiedVersion);
                d.setFilePath(filePath);
                d.setSha1sum(Checksum.getSHA1Checksum((String)filePath));
                d.setSha256sum(Checksum.getSHA256Checksum((String)filePath));
                d.setMd5sum(Checksum.getMD5Checksum((String)filePath));
                d.addEvidence(EvidenceType.PRODUCT, REQUIREMENTS, "product", identifiedPackage, Confidence.HIGHEST);
                d.addEvidence(EvidenceType.VERSION, REQUIREMENTS, "version", identifiedVersion, Confidence.HIGHEST);
                d.addEvidence(EvidenceType.VENDOR, REQUIREMENTS, "vendor", identifiedPackage, Confidence.HIGHEST);
                engine.addDependency(d);
            }
        }
    }

    private String getFileContents(File actualFile) throws AnalysisException {
        try {
            return FileUtils.readFileToString((File)actualFile, (Charset)Charset.defaultCharset()).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }
}

