/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.artifactory;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.data.artifactory.ChecksumsImpl;
import org.owasp.dependencycheck.data.artifactory.FileImpl;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ArtifactorySearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactorySearch.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("^/(?<groupId>.+)/(?<artifactId>[^/]+)/(?<version>[^/]+)/[^/]+$");
    private static final String WHILE_ACTUAL_IS = " while actual is ";
    private final String rootURL;
    private final boolean useProxy;
    private final Settings settings;
    private final ObjectReader objectReader;

    public ArtifactorySearch(Settings settings) {
        String searchUrl;
        this.settings = settings;
        this.rootURL = searchUrl = settings.getString("analyzer.artifactory.url");
        LOGGER.debug("Artifactory Search URL {}", (Object)searchUrl);
        if (null != settings.getString("proxy.server")) {
            boolean useProxySettings = false;
            try {
                useProxySettings = settings.getBoolean("analyzer.artifactory.proxy");
            }
            catch (InvalidSettingException e) {
                LOGGER.error("Settings {} is invalid, only, true/false is valid", (Object)"analyzer.artifactory.proxy", (Object)e);
            }
            this.useProxy = useProxySettings;
            LOGGER.debug("Using proxy? {}", (Object)this.useProxy);
        } else {
            this.useProxy = false;
            LOGGER.debug("Not using proxy");
        }
        this.objectReader = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readerFor(FileImpl.class);
    }

    public List<MavenArtifact> search(Dependency dependency) throws IOException {
        String sha1sum = dependency.getSha1sum();
        URL url = this.buildUrl(sha1sum);
        HttpURLConnection conn = this.connect(url);
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            return this.processResponse(dependency, conn);
        }
        throw new IOException("Could not connect to Artifactory " + url + " (" + responseCode + "): " + conn.getResponseMessage());
    }

    private HttpURLConnection connect(URL url) throws IOException {
        LOGGER.debug("Searching Artifactory url {}", (Object)url);
        URLConnectionFactory factory = new URLConnectionFactory(this.settings);
        HttpURLConnection conn = factory.createHttpURLConnection(url, this.useProxy);
        conn.setDoOutput(true);
        conn.addRequestProperty("X-Result-Detail", "info");
        String username = this.settings.getString("analyzer.artifactory.api.username");
        String apiToken = this.settings.getString("analyzer.artifactory.api.token");
        if (username != null && apiToken != null) {
            String userpassword = username + ":" + apiToken;
            String encodedAuthorization = Base64.getEncoder().encodeToString(userpassword.getBytes(StandardCharsets.UTF_8));
            conn.addRequestProperty("Authorization", "Basic " + encodedAuthorization);
        } else {
            String bearerToken = this.settings.getString("analyzer.artifactory.bearer.token");
            if (bearerToken != null) {
                conn.addRequestProperty("Authorization", "Bearer " + bearerToken);
            }
        }
        conn.connect();
        return conn;
    }

    private URL buildUrl(String sha1sum) throws MalformedURLException {
        return new URL(this.rootURL + "/api/search/checksum?sha1=" + sha1sum);
    }

    protected List<MavenArtifact> processResponse(Dependency dependency, HttpURLConnection conn) throws IOException {
        ArrayList<MavenArtifact> result;
        block27: {
            result = new ArrayList<MavenArtifact>();
            try (InputStreamReader streamReader = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);
                 JsonParser parser = this.objectReader.getFactory().createParser((Reader)streamReader);){
                if (this.init(parser) && parser.nextToken() == JsonToken.START_OBJECT) {
                    do {
                        FileImpl file = (FileImpl)this.objectReader.readValue(parser);
                        this.checkHashes(dependency, file.getChecksums());
                        Matcher pathMatcher = PATH_PATTERN.matcher(file.getPath());
                        if (!pathMatcher.matches()) {
                            throw new IllegalStateException("Cannot extract the Maven information from the path retrieved in Artifactory " + file.getPath());
                        }
                        String groupId = pathMatcher.group("groupId").replace('/', '.');
                        String artifactId = pathMatcher.group("artifactId");
                        String version = pathMatcher.group("version");
                        result.add(new MavenArtifact(groupId, artifactId, version, file.getDownloadUri(), MavenArtifact.derivePomUrl(artifactId, version, file.getDownloadUri())));
                    } while (parser.nextToken() == JsonToken.START_OBJECT);
                    break block27;
                }
                throw new FileNotFoundException("Artifact " + dependency + " not found in Artifactory");
            }
        }
        return result;
    }

    protected boolean init(JsonParser parser) throws IOException {
        JsonToken nextToken = parser.nextToken();
        if (nextToken != JsonToken.START_OBJECT) {
            throw new IOException("Expected " + JsonToken.START_OBJECT + ", got " + nextToken);
        }
        while ((nextToken = parser.nextToken()) != null) {
            if (!nextToken.isStructStart()) continue;
            if (nextToken == JsonToken.START_ARRAY && "results".equals(parser.currentName())) {
                return true;
            }
            parser.skipChildren();
        }
        return false;
    }

    private void checkHashes(Dependency dependency, ChecksumsImpl checksums) throws FileNotFoundException {
        String md5sum = dependency.getMd5sum();
        if (!checksums.getMd5().equals(md5sum)) {
            throw new FileNotFoundException("Artifact found by API is not matching the md5 of the artifact (repository hash is " + checksums.getMd5() + WHILE_ACTUAL_IS + md5sum + ") !");
        }
        String sha1sum = dependency.getSha1sum();
        if (!checksums.getSha1().equals(sha1sum)) {
            throw new FileNotFoundException("Artifact found by API is not matching the SHA1 of the artifact (repository hash is " + checksums.getSha1() + WHILE_ACTUAL_IS + sha1sum + ") !");
        }
        String sha256sum = dependency.getSha256sum();
        if (checksums.getSha256() != null && !checksums.getSha256().equals(sha256sum)) {
            throw new FileNotFoundException("Artifact found by API is not matching the SHA-256 of the artifact (repository hash is " + checksums.getSha256() + WHILE_ACTUAL_IS + sha256sum + ") !");
        }
    }

    public boolean preflightRequest() {
        try {
            URL url = this.buildUrl(Checksum.getSHA1Checksum((String)UUID.randomUUID().toString()));
            HttpURLConnection connection = this.connect(url);
            if (connection.getResponseCode() != 200) {
                LOGGER.warn("Expected 200 result from Artifactory ({}), got {}", (Object)url, (Object)connection.getResponseCode());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Cannot connect to Artifactory", (Throwable)e);
            return false;
        }
    }
}

