/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractNpmAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.DependencyBundlingAnalyzer;
import org.owasp.dependencycheck.analyzer.DependencyMergingAnalyzer;
import org.owasp.dependencycheck.analyzer.NodeAuditAnalyzer;
import org.owasp.dependencycheck.analyzer.YarnAuditAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NodePackageAnalyzer
extends AbstractNpmAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodePackageAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "nodejs";
    private static final String ANALYZER_NAME = "Node.js Package Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String PACKAGE_JSON = "package.json";
    public static final String PACKAGE_LOCK_JSON = "package-lock.json";
    public static final String SHRINKWRAP_JSON = "npm-shrinkwrap.json";
    private static final FileFilter PACKAGE_JSON_FILTER = FileFilterBuilder.newInstance().addFilenames("package.json", "package-lock.json", "npm-shrinkwrap.json").build();

    @Override
    protected FileFilter getFileFilter() {
        return PACKAGE_JSON_FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        if (engine.getMode() != Engine.Mode.EVIDENCE_COLLECTION) {
            try {
                Settings settings = engine.getSettings();
                String[] tmp = settings.getArray("ecosystem.skip.cpeanalyzer");
                if (tmp != null) {
                    List<String> skipEcosystems = Arrays.asList(tmp);
                    if (skipEcosystems.contains(DEPENDENCY_ECOSYSTEM) && !settings.getBoolean("analyzer.ossindex.enabled")) {
                        if (!settings.getBoolean("analyzer.node.audit.enabled")) {
                            String msg = "Invalid Configuration: enabling the Node Package Analyzer without using the Node Audit Analyzer or OSS Index Analyzer is not supported.";
                            throw new InitializationException("Invalid Configuration: enabling the Node Package Analyzer without using the Node Audit Analyzer or OSS Index Analyzer is not supported.");
                        }
                        if (!this.isNodeAuditEnabled(engine)) {
                            String msg = "Missing package.lock or npm-shrinkwrap.lock file: Unable to scan a node project without a package-lock.json or npm-shrinkwrap.json.";
                            throw new InitializationException("Missing package.lock or npm-shrinkwrap.lock file: Unable to scan a node project without a package-lock.json or npm-shrinkwrap.json.");
                        }
                    } else if (skipEcosystems.contains(DEPENDENCY_ECOSYSTEM) && !settings.getBoolean("analyzer.node.audit.enabled")) {
                        LOGGER.warn("Using only the OSS Index Analyzer with Node.js can result in many false positives - please enable the Node Audit Analyzer.");
                    }
                }
            }
            catch (InvalidSettingException ex) {
                throw new InitializationException("Unable to read configuration settings", ex);
            }
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.node.package.enabled";
    }

    private boolean isNodeAuditEnabled(Engine engine) {
        for (Analyzer a : engine.getAnalyzers()) {
            if (!(a instanceof NodeAuditAnalyzer) && !(a instanceof YarnAuditAnalyzer)) continue;
            if (a.isEnabled()) {
                try {
                    ((AbstractNpmAnalyzer)a).prepareFileTypeAnalyzer(engine);
                }
                catch (InitializationException ex) {
                    LOGGER.debug("Error initializing the {}", (Object)a.getName());
                }
            }
            return a.isEnabled();
        }
        return false;
    }

    private boolean noLockFileExists(File dependencyFile) {
        File lock = new File(dependencyFile.getParentFile(), PACKAGE_LOCK_JSON);
        File shrinkwrap = new File(dependencyFile.getParentFile(), SHRINKWRAP_JSON);
        File yarnLock = new File(dependencyFile.getParentFile(), "yarn.lock");
        return !lock.isFile() && !shrinkwrap.isFile() && !yarnLock.isFile();
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File nodeModules;
        File shrinkwrap;
        File dependencyFile;
        if (this.isNodeAuditEnabled(engine) && !PACKAGE_LOCK_JSON.equals(dependency.getFileName()) && !SHRINKWRAP_JSON.equals(dependency.getFileName())) {
            engine.removeDependency(dependency);
        }
        if (!(dependencyFile = dependency.getActualFile()).isFile() || dependencyFile.length() == 0L || !NodePackageAnalyzer.shouldProcess(dependencyFile)) {
            return;
        }
        if (this.noLockFileExists(dependency.getActualFile())) {
            LOGGER.warn("No lock file exists - this will result in false negatives; please run `npm install --package-lock`");
        }
        File baseDir = dependencyFile.getParentFile();
        if (PACKAGE_JSON.equals(dependency.getFileName())) {
            File lockfile = new File(baseDir, PACKAGE_LOCK_JSON);
            File shrinkwrap2 = new File(baseDir, SHRINKWRAP_JSON);
            if (shrinkwrap2.exists() || lockfile.exists()) {
                return;
            }
        } else if (PACKAGE_LOCK_JSON.equals(dependency.getFileName()) && (shrinkwrap = new File(baseDir, SHRINKWRAP_JSON)).exists()) {
            return;
        }
        if (!(nodeModules = new File(baseDir, "node_modules")).isDirectory()) {
            LOGGER.warn("Analyzing `{}` - however, the node_modules directory does not exist. Please run `npm install` prior to running dependency-check", (Object)dependencyFile.toString());
            return;
        }
        try (JsonReader jsonReader = Json.createReader((InputStream)FileUtils.openInputStream((File)dependencyFile));){
            String parentPackage;
            JsonObject json = jsonReader.readObject();
            String parentName = json.getString("name", "");
            String parentVersion = json.getString("version", "");
            if (parentName.isEmpty()) {
                return;
            }
            dependency.setName(parentName);
            if (!parentVersion.isEmpty()) {
                dependency.setVersion(parentVersion);
                parentPackage = String.format("%s:%s", parentName, parentVersion);
            } else {
                parentPackage = parentName;
            }
            this.processDependencies(json, baseDir, dependencyFile, parentPackage, engine);
        }
        catch (JsonException e) {
            LOGGER.warn("Failed to parse package.json file.", (Throwable)e);
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
    }

    public static boolean shouldSkipDependency(String name, String version, boolean optional, boolean fileExist) {
        if (version.startsWith("npm:")) {
            LOGGER.warn("dependency skipped: package.json contain an alias for {} => {} npm audit doesn't support aliases", (Object)name, (Object)version.replace("npm:", ""));
            return true;
        }
        if (optional && !fileExist) {
            LOGGER.warn("dependency skipped: node module {} seems optional and not installed", (Object)name);
            return true;
        }
        if (version.startsWith("file:")) {
            LOGGER.warn("dependency skipped: package.json contain an local node_module for {} seems to be located {} npm audit doesn't support locally referenced modules", (Object)name, (Object)version.replace("file:", ""));
            return true;
        }
        return false;
    }

    public static boolean shouldSkipDependency(String name, String version) {
        return NodePackageAnalyzer.shouldSkipDependency(name, version, false, true);
    }

    private void processDependencies(JsonObject json, File baseDir, File rootFile, String parentPackage, Engine engine) throws AnalysisException {
        if (json.containsKey((Object)"dependencies")) {
            JsonObject deps = json.getJsonObject("dependencies");
            for (Map.Entry entry : deps.entrySet()) {
                Dependency child;
                String version;
                String name = (String)entry.getKey();
                boolean optional = false;
                File base = Paths.get(baseDir.getPath(), "node_modules", name).toFile();
                File f = new File(base, PACKAGE_JSON);
                JsonObject jo = null;
                if (entry.getValue() instanceof JsonObject) {
                    jo = (JsonObject)entry.getValue();
                    version = jo.getString("version");
                    optional = jo.getBoolean("optional", false);
                } else {
                    version = ((JsonString)entry.getValue()).getString();
                }
                if (NodePackageAnalyzer.shouldSkipDependency(name, version, optional, f.exists())) continue;
                if (null != jo && jo.containsKey((Object)"dependencies")) {
                    String subPackageName = String.format("%s/%s:%s", parentPackage, name, version);
                    this.processDependencies(jo, base, rootFile, subPackageName, engine);
                }
                if (f.exists()) {
                    child = new Dependency(f);
                    child.setEcosystem(DEPENDENCY_ECOSYSTEM);
                    try (JsonReader jr = Json.createReader((InputStream)FileUtils.openInputStream((File)f));){
                        JsonObject childJson = jr.readObject();
                        this.gatherEvidence(childJson, child);
                    }
                    catch (JsonException e) {
                        LOGGER.warn("Failed to parse package.json file from dependency.", (Throwable)e);
                    }
                    catch (IOException e) {
                        throw new AnalysisException("Problem occurred while reading dependency file.", e);
                    }
                } else {
                    LOGGER.warn("Unable to find node module: {}", (Object)f.toString());
                    child = new Dependency(rootFile, true);
                    child.setEcosystem(DEPENDENCY_ECOSYSTEM);
                    child.setSha1sum(Checksum.getSHA1Checksum((String)String.format("%s:%s", name, version)));
                    child.setSha256sum(Checksum.getSHA256Checksum((String)String.format("%s:%s", name, version)));
                    child.setMd5sum(Checksum.getMD5Checksum((String)String.format("%s:%s", name, version)));
                    child.addEvidence(EvidenceType.VENDOR, rootFile.getName(), "name", name, Confidence.HIGHEST);
                    child.addEvidence(EvidenceType.PRODUCT, rootFile.getName(), "name", name, Confidence.HIGHEST);
                    child.addEvidence(EvidenceType.VERSION, rootFile.getName(), "version", version, Confidence.HIGHEST);
                    child.setName(name);
                    child.setVersion(version);
                    String packagePath = String.format("%s:%s", name, version);
                    child.setDisplayFileName(packagePath);
                    child.setPackagePath(packagePath);
                    try {
                        PackageURL purl = PackageURLBuilder.aPackageURL().withType("npm").withName(name).withVersion(version).build();
                        PurlIdentifier id = new PurlIdentifier(purl, Confidence.HIGHEST);
                        child.addSoftwareIdentifier(id);
                    }
                    catch (MalformedPackageURLException ex) {
                        LOGGER.debug("Unable to build package url for `" + packagePath + "`", (Throwable)ex);
                    }
                }
                child.addProjectReference(parentPackage);
                child.setEcosystem(DEPENDENCY_ECOSYSTEM);
                Dependency existing = this.findDependency(engine, name, version);
                if (existing != null) {
                    if (existing.isVirtual()) {
                        DependencyMergingAnalyzer.mergeDependencies(child, existing, null);
                        engine.removeDependency(existing);
                        engine.addDependency(child);
                        continue;
                    }
                    DependencyBundlingAnalyzer.mergeDependencies(existing, child, null);
                    continue;
                }
                engine.addDependency(child);
            }
        }
    }
}

