/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import javax.json.stream.JsonParsingException;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.processing.GoModProcessor;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.processing.ProcessReader;
import org.owasp.dependencycheck.utils.processing.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class GolangModAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GolangModAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "golang";
    private static final String ANALYZER_NAME = "Golang Mod Analyzer";
    public static final String GO_MOD = "go.mod";
    private static String goPath = null;
    private static final FileFilter GO_MOD_FILTER = FileFilterBuilder.newInstance().addFilenames("go.mod").build();

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.golang.mod.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return GO_MOD_FILTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGo() {
        GolangModAnalyzer golangModAnalyzer = this;
        synchronized (golangModAnalyzer) {
            if (goPath == null) {
                String path = this.getSettings().getString("analyzer.golang.path");
                if (path == null) {
                    goPath = "go";
                } else {
                    File goFile = new File(path);
                    if (goFile.isFile()) {
                        goPath = goFile.getAbsolutePath();
                    } else {
                        LOGGER.warn("Provided path to `go` executable is invalid. Trying default location. If you do want to set it, please set the `{}` property", (Object)"analyzer.golang.path");
                        goPath = "go";
                    }
                }
            }
        }
        return goPath;
    }

    private Process testGoMod(File folder) throws AnalysisException, IOException {
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getGo());
        args.add("mod");
        args.add("edit");
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(folder);
        LOGGER.debug("Launching: {} from {}", args, (Object)folder);
        return builder.start();
    }

    private Process launchGoListReadonly(File folder) throws AnalysisException {
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getGo());
        args.add("list");
        args.add("-json");
        args.add("-m");
        args.add("-mod=readonly");
        args.add("all");
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(folder);
        try {
            LOGGER.debug("Launching: {} from {}", args, (Object)folder);
            return builder.start();
        }
        catch (IOException ioe) {
            throw new AnalysisException("go initialization failure; this error can be ignored if you are not analyzing Go. Otherwise ensure that go is installed and the path to go is correctly specified", ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressFBWarnings(justification="The fallthrough is intentional to avoid code duplication", value={"SF_SWITCH_NO_DEFAULT"})
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        File tempDirectory;
        this.setEnabled(false);
        try {
            tempDirectory = this.getSettings().getTempDirectory();
        }
        catch (IOException ex) {
            throw new InitializationException("Unable to create temporary file, the Go Mod Analyzer will be disabled", ex);
        }
        try {
            Process process = this.testGoMod(tempDirectory);
            try (ProcessReader processReader = new ProcessReader(process);){
                processReader.readAll();
                int exitValue = process.waitFor();
                boolean expectedNoModuleFoundExitValue = true;
                int possiblyGoTooOldExitValue = 2;
                int goExecutableNotFoundExitValue = 127;
                switch (exitValue) {
                    case 1: {
                        this.setEnabled(true);
                        LOGGER.debug("{} is enabled.", (Object)ANALYZER_NAME);
                        return;
                    }
                    case 127: {
                        throw new InitializationException(String.format("Go executable not found. Disabling %s: %s", ANALYZER_NAME, exitValue));
                    }
                    case 2: {
                        String error = processReader.getError();
                        if (!StringUtils.isBlank((CharSequence)error)) {
                            if (error.contains("unknown subcommand \"mod\"")) {
                                LOGGER.warn("Your version of `go` does not support modules. Disabling {}. Error: `{}`", (Object)ANALYZER_NAME, (Object)error);
                                throw new InitializationException("Go version does not support modules.");
                            }
                            LOGGER.warn("An error occurred calling `go` - no output could be read. Disabling {}.", (Object)ANALYZER_NAME);
                            throw new InitializationException("Error calling `go` - no output could be read.");
                        }
                    }
                    default: {
                        String msg = String.format("Unexpected exit code from go process. Disabling %s: %s", ANALYZER_NAME, exitValue);
                        throw new InitializationException(msg);
                    }
                }
            }
        }
        catch (AnalysisException ae) {
            String msg = String.format("Exception from go process: %s. Disabling %s", ae.getCause(), ANALYZER_NAME);
            throw new InitializationException(msg, ae);
        }
        catch (InterruptedException ex) {
            String msg = String.format("Go mod process was interrupted. Disabling %s", ANALYZER_NAME);
            Thread.currentThread().interrupt();
            throw new InitializationException(msg);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File parentFile = dependency.getActualFile().getParentFile();
        Process process = this.launchGoListReadonly(parentFile);
        String error = null;
        try (GoModProcessor processor = new GoModProcessor(dependency, engine);
             ProcessReader processReader = new ProcessReader(process, (Processor)processor);){
            int exitValue;
            processReader.readAll();
            error = processReader.getError();
            if (!StringUtils.isBlank((CharSequence)error)) {
                LOGGER.warn("Warnings from `go`: {}", (Object)error);
            }
            if ((exitValue = process.exitValue()) < 0 || exitValue > 1) {
                String msg = String.format("Unexpected exit code from go process; exit code: %s", exitValue);
                throw new AnalysisException(msg);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new AnalysisException("go process interrupted", ie);
        }
        catch (IOException ex) {
            throw new AnalysisException("Error closing the go process", ex);
        }
        catch (JsonParsingException ex) {
            String msg = error != null ? "Unable to process output from `go list -json -m -mod=readonly all`; the command reported the following errors: " + error : "Unable to process output from `go list -json -m -mod=readonly all`; please validate that the command runs without errors.";
            throw new AnalysisException(msg, ex);
        }
    }
}

